/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import io.druid.segment.GenericColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.data.CompressedFloatsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.IOPeon;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class FloatColumnSerializer
implements GenericColumnSerializer {
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private CompressedFloatsSupplierSerializer writer;

    public static FloatColumnSerializer create(IOPeon ioPeon, String filenameBase, CompressedObjectStrategy.CompressionStrategy compression) {
        return new FloatColumnSerializer(ioPeon, filenameBase, IndexIO.BYTE_ORDER, compression);
    }

    public FloatColumnSerializer(IOPeon ioPeon, String filenameBase, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressedFloatsSupplierSerializer.create(this.ioPeon, String.format("%s.float_column", this.filenameBase), this.byteOrder, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        float val = obj == null ? 0.0f : ((Number)obj).floatValue();
        this.writer.add(val);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long getSerializedSize() {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        this.writer.writeToChannel(channel);
    }
}

