/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Strings;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.guava.CloseQuietly;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.segment.ColumnSelector;
import io.druid.segment.column.BitmapIndex;
import io.druid.segment.column.Column;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import java.io.Closeable;
import java.util.Iterator;

public class ColumnSelectorBitmapIndexSelector
implements BitmapIndexSelector {
    private final BitmapFactory bitmapFactory;
    private final ColumnSelector index;

    public ColumnSelectorBitmapIndexSelector(BitmapFactory bitmapFactory, ColumnSelector index) {
        this.bitmapFactory = bitmapFactory;
        this.index = index;
    }

    @Override
    public Indexed<String> getDimensionValues(String dimension) {
        Column columnDesc = this.index.getColumn(dimension);
        if (columnDesc == null || !columnDesc.getCapabilities().isDictionaryEncoded()) {
            return null;
        }
        final DictionaryEncodedColumn column = columnDesc.getDictionaryEncoding();
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return column.getCardinality();
            }

            @Override
            public String get(int index) {
                return column.lookupName(index);
            }

            @Override
            public int indexOf(String value) {
                return column.lookupId(value);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    @Override
    public int getNumRows() {
        int n;
        GenericColumn column = null;
        try {
            column = this.index.getColumn("__time").getGenericColumn();
            n = column.length();
        }
        catch (Throwable throwable) {
            CloseQuietly.close(column);
            throw throwable;
        }
        CloseQuietly.close((Closeable)column);
        return n;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    @Override
    public BitmapIndex getBitmapIndex(String dimension) {
        Column column = this.index.getColumn(dimension);
        if (column != null && column.getCapabilities().hasBitmapIndexes()) {
            return column.getBitmapIndex();
        }
        return null;
    }

    @Override
    public ImmutableBitmap getBitmapIndex(String dimension, String value) {
        Column column = this.index.getColumn(dimension);
        if (column == null) {
            if (Strings.isNullOrEmpty((String)value)) {
                return this.bitmapFactory.complement(this.bitmapFactory.makeEmptyImmutableBitmap(), this.getNumRows());
            }
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        if (!column.getCapabilities().hasBitmapIndexes()) {
            return this.bitmapFactory.makeEmptyImmutableBitmap();
        }
        BitmapIndex bitmapIndex = column.getBitmapIndex();
        return bitmapIndex.getBitmap(bitmapIndex.getIndex(value));
    }

    @Override
    public ImmutableRTree getSpatialIndex(String dimension) {
        Column column = this.index.getColumn(dimension);
        if (column == null || !column.getCapabilities().hasSpatialIndexes()) {
            return new ImmutableRTree();
        }
        return column.getSpatialIndex().getRTree();
    }
}

