/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.druid.granularity.QueryGranularities;
import io.druid.granularity.QueryGranularity;
import io.druid.query.BaseQuery;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.Result;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.LexicographicSearchSortSpec;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.query.search.search.SearchSortSpec;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.List;
import java.util.Map;

public class SearchQuery
extends BaseQuery<Result<SearchResultValue>> {
    private final DimFilter dimFilter;
    private final SearchSortSpec sortSpec;
    private final QueryGranularity granularity;
    private final List<DimensionSpec> dimensions;
    private final SearchQuerySpec querySpec;
    private final int limit;

    @JsonCreator
    public SearchQuery(@JsonProperty(value="dataSource") DataSource dataSource, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="granularity") QueryGranularity granularity, @JsonProperty(value="limit") int limit, @JsonProperty(value="intervals") QuerySegmentSpec querySegmentSpec, @JsonProperty(value="searchDimensions") List<DimensionSpec> dimensions, @JsonProperty(value="query") SearchQuerySpec querySpec, @JsonProperty(value="sort") SearchSortSpec sortSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(dataSource, querySegmentSpec, false, context);
        this.dimFilter = dimFilter;
        this.sortSpec = sortSpec == null ? new LexicographicSearchSortSpec() : sortSpec;
        this.granularity = granularity == null ? QueryGranularities.ALL : granularity;
        this.limit = limit == 0 ? 1000 : limit;
        this.dimensions = dimensions;
        this.querySpec = querySpec;
        Preconditions.checkNotNull((Object)querySegmentSpec, (Object)"Must specify an interval");
        Preconditions.checkNotNull((Object)querySpec, (Object)"Must specify a query");
    }

    @Override
    public boolean hasFilters() {
        return this.dimFilter != null;
    }

    @Override
    public String getType() {
        return "search";
    }

    public SearchQuery withQuerySegmentSpec(QuerySegmentSpec spec) {
        return new SearchQuery(this.getDataSource(), this.dimFilter, this.granularity, this.limit, spec, this.dimensions, this.querySpec, this.sortSpec, this.getContext());
    }

    @Override
    public Query<Result<SearchResultValue>> withDataSource(DataSource dataSource) {
        return new SearchQuery(dataSource, this.dimFilter, this.granularity, this.limit, this.getQuerySegmentSpec(), this.dimensions, this.querySpec, this.sortSpec, this.getContext());
    }

    public SearchQuery withOverriddenContext(Map<String, Object> contextOverrides) {
        return new SearchQuery(this.getDataSource(), this.dimFilter, this.granularity, this.limit, this.getQuerySegmentSpec(), this.dimensions, this.querySpec, this.sortSpec, this.computeOverridenContext(contextOverrides));
    }

    public SearchQuery withDimFilter(DimFilter dimFilter) {
        return new SearchQuery(this.getDataSource(), dimFilter, this.granularity, this.limit, this.getQuerySegmentSpec(), this.dimensions, this.querySpec, this.sortSpec, this.getContext());
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    @JsonProperty
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="searchDimensions")
    public List<DimensionSpec> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="query")
    public SearchQuerySpec getQuery() {
        return this.querySpec;
    }

    @JsonProperty(value="sort")
    public SearchSortSpec getSort() {
        return this.sortSpec;
    }

    public SearchQuery withLimit(int newLimit) {
        return new SearchQuery(this.getDataSource(), this.dimFilter, this.granularity, newLimit, this.getQuerySegmentSpec(), this.dimensions, this.querySpec, this.sortSpec, this.getContext());
    }

    public String toString() {
        return "SearchQuery{dataSource='" + this.getDataSource() + '\'' + ", dimFilter=" + this.dimFilter + ", granularity='" + this.granularity + '\'' + ", dimensions=" + this.dimensions + ", querySpec=" + this.querySpec + ", querySegmentSpec=" + this.getQuerySegmentSpec() + ", limit=" + this.limit + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchQuery that = (SearchQuery)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.dimFilter != null ? !this.dimFilter.equals(that.dimFilter) : that.dimFilter != null) {
            return false;
        }
        if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(that.granularity) : that.granularity != null) {
            return false;
        }
        if (this.querySpec != null ? !this.querySpec.equals(that.querySpec) : that.querySpec != null) {
            return false;
        }
        return !(this.sortSpec != null ? !this.sortSpec.equals(that.sortSpec) : that.sortSpec != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.dimFilter != null ? this.dimFilter.hashCode() : 0);
        result = 31 * result + (this.sortSpec != null ? this.sortSpec.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.querySpec != null ? this.querySpec.hashCode() : 0);
        result = 31 * result + this.limit;
        return result;
    }
}

