/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search;

import com.google.inject.Inject;
import io.druid.query.ChainedExecutionQueryRunner;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryWatcher;
import io.druid.query.Result;
import io.druid.query.search.SearchQueryQueryToolChest;
import io.druid.query.search.SearchQueryRunner;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.SearchQuery;
import io.druid.segment.Segment;
import java.util.concurrent.ExecutorService;

public class SearchQueryRunnerFactory
implements QueryRunnerFactory<Result<SearchResultValue>, SearchQuery> {
    private final SearchQueryQueryToolChest toolChest;
    private final QueryWatcher queryWatcher;

    @Inject
    public SearchQueryRunnerFactory(SearchQueryQueryToolChest toolChest, QueryWatcher queryWatcher) {
        this.toolChest = toolChest;
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> createRunner(Segment segment) {
        return new SearchQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> mergeRunners(ExecutorService queryExecutor, Iterable<QueryRunner<Result<SearchResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<SearchResultValue>>(queryExecutor, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<SearchResultValue>, SearchQuery> getToolchest() {
        return this.toolChest;
    }
}

