/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.orderby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import io.druid.query.groupby.orderby.OrderedPriorityQueueItems;

public class TopNSorter<T> {
    private Ordering<T> ordering;

    public TopNSorter(Ordering<T> ordering) {
        this.ordering = ordering;
    }

    public Iterable<T> toTopN(Iterable<T> items, int n) {
        if (n <= 0) {
            return ImmutableList.of();
        }
        MinMaxPriorityQueue queue = MinMaxPriorityQueue.orderedBy(this.ordering).maximumSize(n).create(items);
        return new OrderedPriorityQueueItems(queue);
    }
}

