/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;

public class HyperUniquesBufferAggregator
implements BufferAggregator {
    private static final byte[] EMPTY_BYTES = HyperLogLogCollector.makeEmptyVersionedByteArray();
    private final ObjectColumnSelector selector;

    public HyperUniquesBufferAggregator(ObjectColumnSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.put(EMPTY_BYTES);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        HyperLogLogCollector collector = (HyperLogLogCollector)this.selector.get();
        if (collector == null) {
            return;
        }
        HyperLogLogCollector.makeCollector((ByteBuffer)buf.duplicate().position(position).limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage())).fold(collector);
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        int size = HyperLogLogCollector.getLatestNumBytesForDenseStorage();
        ByteBuffer dataCopyBuffer = ByteBuffer.allocate(size);
        ByteBuffer mutationBuffer = buf.duplicate();
        mutationBuffer.position(position);
        mutationBuffer.limit(position + size);
        dataCopyBuffer.put(mutationBuffer);
        dataCopyBuffer.rewind();
        return HyperLogLogCollector.makeCollector(dataCopyBuffer);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("HyperUniquesBufferAggregator does not support getLong()");
    }

    @Override
    public void close() {
    }
}

