/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.base.Joiner;
import io.druid.timeline.DataSegment;
import org.joda.time.format.ISODateTimeFormat;

public class DataSegmentPusherUtil {
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();

    public static String getStorageDir(DataSegment segment) {
        return JOINER.join((Object)segment.getDataSource(), (Object)String.format("%s_%s", segment.getInterval().getStart(), segment.getInterval().getEnd()), new Object[]{segment.getVersion(), segment.getShardSpec().getPartitionNum()});
    }

    public static String getHdfsStorageDir(DataSegment segment) {
        return JOINER.join((Object)segment.getDataSource(), (Object)String.format("%s_%s", segment.getInterval().getStart().toString(ISODateTimeFormat.basicDateTime()), segment.getInterval().getEnd().toString(ISODateTimeFormat.basicDateTime())), new Object[]{segment.getVersion().replaceAll(":", "_"), segment.getShardSpec().getPartitionNum()});
    }
}

