/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.views;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.views.ViewConfigurable;
import io.dropwizard.views.ViewMessageBodyWriter;
import io.dropwizard.views.ViewRenderer;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class ViewBundle<T extends Configuration>
implements ConfiguredBundle<T>,
ViewConfigurable<T> {
    private final Iterable<ViewRenderer> viewRenderers;

    public ViewBundle() {
        this(ServiceLoader.load(ViewRenderer.class));
    }

    public ViewBundle(Iterable<ViewRenderer> viewRenderers) {
        this.viewRenderers = ImmutableSet.copyOf(viewRenderers);
    }

    public void run(T configuration, Environment environment) throws Exception {
        ImmutableMap empty = ImmutableMap.of();
        ImmutableMap options = this.getViewConfiguration((Configuration)configuration);
        Iterator<ViewRenderer> iterator = this.viewRenderers.iterator();
        while (iterator.hasNext()) {
            ViewRenderer viewRenderer;
            ImmutableMap viewOptions = (ImmutableMap)options.get((Object)(viewRenderer = iterator.next()).getSuffix());
            viewRenderer.configure((ImmutableMap<String, String>)(viewOptions == null ? empty : viewOptions));
        }
        environment.jersey().register((Object)new ViewMessageBodyWriter(environment.metrics(), this.viewRenderers));
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }
}

