/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.dropwizard.util.DataSizeUnit;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSize
implements Comparable<DataSize>,
Serializable {
    private static final long serialVersionUID = 8517642678733072800L;
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)\\s*(\\S*)");
    private static final SortedMap<String, DataSizeUnit> SUFFIXES;
    private final long count;
    private final DataSizeUnit unit;

    public static DataSize bytes(long count) {
        return new DataSize(count, DataSizeUnit.BYTES);
    }

    public static DataSize kilobytes(long count) {
        return new DataSize(count, DataSizeUnit.KILOBYTES);
    }

    public static DataSize megabytes(long count) {
        return new DataSize(count, DataSizeUnit.MEGABYTES);
    }

    public static DataSize gigabytes(long count) {
        return new DataSize(count, DataSizeUnit.GIGABYTES);
    }

    public static DataSize terabytes(long count) {
        return new DataSize(count, DataSizeUnit.TERABYTES);
    }

    public static DataSize petabytes(long count) {
        return new DataSize(count, DataSizeUnit.PETABYTES);
    }

    public static DataSize kibibytes(long count) {
        return new DataSize(count, DataSizeUnit.KIBIBYTES);
    }

    public static DataSize mebibytes(long count) {
        return new DataSize(count, DataSizeUnit.MEBIBYTES);
    }

    public static DataSize gibibytes(long count) {
        return new DataSize(count, DataSizeUnit.GIBIBYTES);
    }

    public static DataSize tebibytes(long count) {
        return new DataSize(count, DataSizeUnit.TEBIBYTES);
    }

    public static DataSize pebibytes(long count) {
        return new DataSize(count, DataSizeUnit.PEBIBYTES);
    }

    @JsonCreator
    public static DataSize parse(CharSequence size) {
        return DataSize.parse(size, DataSizeUnit.BYTES);
    }

    public static DataSize parse(CharSequence size, DataSizeUnit defaultUnit) {
        DataSizeUnit dataSizeUnit;
        Matcher matcher = SIZE_PATTERN.matcher(size);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid size: " + String.valueOf(size));
        }
        long count = Long.parseLong(matcher.group(1));
        String unit = matcher.group(2);
        DataSizeUnit dataSizeUnit2 = dataSizeUnit = unit == null || unit.isEmpty() ? defaultUnit : (DataSizeUnit)((Object)SUFFIXES.get(unit));
        if (dataSizeUnit == null) {
            throw new IllegalArgumentException("Invalid size: " + String.valueOf(size) + ". Wrong size unit");
        }
        return new DataSize(count, dataSizeUnit);
    }

    private DataSize(long count, DataSizeUnit unit) {
        this.count = count;
        this.unit = Objects.requireNonNull(unit);
    }

    public long getQuantity() {
        return this.count;
    }

    public DataSizeUnit getUnit() {
        return this.unit;
    }

    public long toBytes() {
        return DataSizeUnit.BYTES.convert(this.count, this.unit);
    }

    public long toKilobytes() {
        return DataSizeUnit.KILOBYTES.convert(this.count, this.unit);
    }

    public long toMegabytes() {
        return DataSizeUnit.MEGABYTES.convert(this.count, this.unit);
    }

    public long toGigabytes() {
        return DataSizeUnit.GIGABYTES.convert(this.count, this.unit);
    }

    public long toTerabytes() {
        return DataSizeUnit.TERABYTES.convert(this.count, this.unit);
    }

    public long toPetabytes() {
        return DataSizeUnit.PETABYTES.convert(this.count, this.unit);
    }

    public long toKibibytes() {
        return DataSizeUnit.KIBIBYTES.convert(this.count, this.unit);
    }

    public long toMebibytes() {
        return DataSizeUnit.MEBIBYTES.convert(this.count, this.unit);
    }

    public long toGibibytes() {
        return DataSizeUnit.GIBIBYTES.convert(this.count, this.unit);
    }

    public long toTebibytes() {
        return DataSizeUnit.TEBIBYTES.convert(this.count, this.unit);
    }

    public long toPebibytes() {
        return DataSizeUnit.PEBIBYTES.convert(this.count, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataSize size = (DataSize)obj;
        return this.count == size.count && this.unit == size.unit;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + " " + units;
    }

    @Override
    public int compareTo(DataSize other) {
        if (this.unit == other.unit) {
            return Long.compare(this.count, other.count);
        }
        return Long.compare(this.toBytes(), other.toBytes());
    }

    static {
        TreeMap<String, DataSizeUnit> suffixes = new TreeMap<String, DataSizeUnit>(String.CASE_INSENSITIVE_ORDER);
        suffixes.put("B", DataSizeUnit.BYTES);
        suffixes.put("byte", DataSizeUnit.BYTES);
        suffixes.put("bytes", DataSizeUnit.BYTES);
        suffixes.put("K", DataSizeUnit.KILOBYTES);
        suffixes.put("KB", DataSizeUnit.KILOBYTES);
        suffixes.put("KiB", DataSizeUnit.KIBIBYTES);
        suffixes.put("kilobyte", DataSizeUnit.KILOBYTES);
        suffixes.put("kibibyte", DataSizeUnit.KIBIBYTES);
        suffixes.put("kilobytes", DataSizeUnit.KILOBYTES);
        suffixes.put("kibibytes", DataSizeUnit.KIBIBYTES);
        suffixes.put("M", DataSizeUnit.MEGABYTES);
        suffixes.put("MB", DataSizeUnit.MEGABYTES);
        suffixes.put("MiB", DataSizeUnit.MEBIBYTES);
        suffixes.put("megabyte", DataSizeUnit.MEGABYTES);
        suffixes.put("mebibyte", DataSizeUnit.MEBIBYTES);
        suffixes.put("megabytes", DataSizeUnit.MEGABYTES);
        suffixes.put("mebibytes", DataSizeUnit.MEBIBYTES);
        suffixes.put("G", DataSizeUnit.GIGABYTES);
        suffixes.put("GB", DataSizeUnit.GIGABYTES);
        suffixes.put("GiB", DataSizeUnit.GIBIBYTES);
        suffixes.put("gigabyte", DataSizeUnit.GIGABYTES);
        suffixes.put("gibibyte", DataSizeUnit.GIBIBYTES);
        suffixes.put("gigabytes", DataSizeUnit.GIGABYTES);
        suffixes.put("gibibytes", DataSizeUnit.GIBIBYTES);
        suffixes.put("T", DataSizeUnit.TERABYTES);
        suffixes.put("TB", DataSizeUnit.TERABYTES);
        suffixes.put("TiB", DataSizeUnit.TEBIBYTES);
        suffixes.put("terabyte", DataSizeUnit.TERABYTES);
        suffixes.put("tebibyte", DataSizeUnit.TEBIBYTES);
        suffixes.put("terabytes", DataSizeUnit.TERABYTES);
        suffixes.put("tebibytes", DataSizeUnit.TEBIBYTES);
        suffixes.put("P", DataSizeUnit.PETABYTES);
        suffixes.put("PB", DataSizeUnit.PETABYTES);
        suffixes.put("PiB", DataSizeUnit.PEBIBYTES);
        suffixes.put("petabyte", DataSizeUnit.PETABYTES);
        suffixes.put("pebibyte", DataSizeUnit.PEBIBYTES);
        suffixes.put("petabytes", DataSizeUnit.PETABYTES);
        suffixes.put("pebibytes", DataSizeUnit.PEBIBYTES);
        SUFFIXES = Collections.unmodifiableSortedMap(suffixes);
    }
}

