/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import java.io.File;
import java.net.URL;
import java.util.Optional;

public class JarLocation {
    private final Class<?> klass;

    public JarLocation(Class<?> klass) {
        this.klass = klass;
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.klass.getPackage()).map(Package::getImplementationVersion);
    }

    public String toString() {
        URL location = this.klass.getProtectionDomain().getCodeSource().getLocation();
        try {
            String jar = new File(location.toURI()).getName();
            if (jar.endsWith(".jar")) {
                return jar;
            }
            return "project.jar";
        }
        catch (Exception ignored) {
            return "project.jar";
        }
    }
}

