/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit5;

import io.dropwizard.testing.junit5.DropwizardExtension;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ReflectionUtils;

public class DropwizardExtensionsSupport
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static Set<Field> findAnnotatedFields(Class<?> testClass, boolean isStaticMember) {
        Set<Field> set = Arrays.stream(testClass.getDeclaredFields()).filter(m -> isStaticMember == Modifier.isStatic(m.getModifiers())).filter(m -> DropwizardExtension.class.isAssignableFrom(m.getType())).collect(Collectors.toSet());
        if (!testClass.getSuperclass().equals(Object.class)) {
            set.addAll(DropwizardExtensionsSupport.findAnnotatedFields(testClass.getSuperclass(), isStaticMember));
        }
        return set;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        try {
            for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(extensionContext.getRequiredTestClass(), true)) {
                ((DropwizardExtension)((Field)ReflectionUtils.makeAccessible((AccessibleObject)member)).get(null)).after();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        Object testInstance = extensionContext.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        try {
            for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(testInstance.getClass(), false)) {
                ((DropwizardExtension)((Field)ReflectionUtils.makeAccessible((AccessibleObject)member)).get(testInstance)).after();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        try {
            for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(extensionContext.getRequiredTestClass(), true)) {
                ((DropwizardExtension)((Field)ReflectionUtils.makeAccessible((AccessibleObject)member)).get(null)).before();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Object testInstance = extensionContext.getTestInstance().orElseThrow(() -> new IllegalStateException("Unable to get the current test instance"));
        try {
            for (Field member : DropwizardExtensionsSupport.findAnnotatedFields(testInstance.getClass(), false)) {
                ((DropwizardExtension)((Field)ReflectionUtils.makeAccessible((AccessibleObject)member)).get(testInstance)).before();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

