/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.assets;

import io.dropwizard.servlets.assets.ResourceNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ResourceURL {
    private ResourceURL() {
    }

    public static boolean isDirectory(URL resourceURL) throws URISyntaxException {
        String protocol;
        switch (protocol = resourceURL.getProtocol()) {
            case "jar": {
                try {
                    ZipEntry zipEntry;
                    JarURLConnection jarConnection = (JarURLConnection)resourceURL.openConnection();
                    JarEntry entry = jarConnection.getJarEntry();
                    if (entry.isDirectory()) {
                        return true;
                    }
                    String relativeFilePath = entry.getName();
                    JarFile jarFile = jarConnection.getJarFile();
                    InputStream inputStream = jarFile.getInputStream(zipEntry = jarFile.getEntry(relativeFilePath));
                    return inputStream == null;
                }
                catch (IOException e) {
                    throw new ResourceNotFoundException(e);
                }
            }
            case "file": {
                return new File(resourceURL.toURI()).isDirectory();
            }
        }
        throw new IllegalArgumentException("Unsupported protocol " + resourceURL.getProtocol() + " for resource " + String.valueOf(resourceURL));
    }

    public static URL appendTrailingSlash(URL originalURL) {
        try {
            return originalURL.getPath().endsWith("/") ? originalURL : new URL(originalURL.getProtocol(), originalURL.getHost(), originalURL.getPort(), originalURL.getFile() + "/");
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException("Invalid resource URL: " + String.valueOf(originalURL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL resourceURL) {
        String protocol;
        switch (protocol = resourceURL.getProtocol()) {
            case "jar": {
                try {
                    JarURLConnection jarConnection = (JarURLConnection)resourceURL.openConnection();
                    JarEntry entry = jarConnection.getJarEntry();
                    return entry.getTime();
                }
                catch (IOException jarConnection) {
                    return 0L;
                }
            }
            case "file": {
                URLConnection connection = null;
                try {
                    connection = resourceURL.openConnection();
                    long l = connection.getLastModified();
                    return l;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.getInputStream().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return 0L;
            }
        }
        throw new IllegalArgumentException("Unsupported protocol " + protocol + " for resource " + String.valueOf(resourceURL));
    }
}

