/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbLocksCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    public DbLocksCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super("locks", "Manage database migration locks", strategy, configurationClass, migrationsFileName);
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-l", "--list"}).dest("list").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)Boolean.FALSE).help("list all open locks");
        subparser.addArgument(new String[]{"-r", "--force-release"}).dest("release").action((ArgumentAction)Arguments.storeTrue()).setDefault((Object)Boolean.FALSE).help("forcibly release all open locks");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        Boolean list = namespace.getBoolean("list");
        Boolean release = namespace.getBoolean("release");
        if (!list.booleanValue() && !release.booleanValue()) {
            throw new IllegalArgumentException("Must specify either --list or --force-release");
        }
        if (list.booleanValue()) {
            liquibase.reportLocks(System.out);
        } else {
            liquibase.forceReleaseLocks();
        }
    }
}

