/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbRollbackCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    public DbRollbackCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass) {
        super("rollback", "Rollback the database schema to a previous version.", strategy, configurationClass);
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-n", "--dry-run"}).action((ArgumentAction)Arguments.storeTrue()).dest("dry-run").setDefault((Object)Boolean.FALSE).help("Output the DDL to stdout, don't run it");
        subparser.addArgument(new String[]{"-t", "--tag"}).dest("tag").help("Rollback to the given tag");
        subparser.addArgument(new String[]{"-d", "--date"}).dest("date").type(Date.class).help("Rollback to the given date");
        subparser.addArgument(new String[]{"-c", "--count"}).dest("count").type(Integer.class).help("Rollback the specified number of change sets");
        subparser.addArgument(new String[]{"-i", "--include"}).action((ArgumentAction)Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        String tag = namespace.getString("tag");
        Integer count = namespace.getInt("count");
        Date date = (Date)namespace.get("date");
        Boolean dryRun = namespace.getBoolean("dry-run");
        String context = this.getContext(namespace);
        if (count == null && tag == null && date == null || count != null && tag != null || count != null && date != null || tag != null && date != null) {
            throw new IllegalArgumentException("Must specify either a count, a tag, or a date.");
        }
        if (count != null) {
            if (dryRun.booleanValue()) {
                liquibase.rollback(count.intValue(), context, (Writer)new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8));
            } else {
                liquibase.rollback(count.intValue(), context);
            }
        } else if (tag != null) {
            if (dryRun.booleanValue()) {
                liquibase.rollback(tag, context, (Writer)new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8));
            } else {
                liquibase.rollback(tag, context);
            }
        } else if (dryRun.booleanValue()) {
            liquibase.rollback(date, context, (Writer)new OutputStreamWriter((OutputStream)System.out, Charsets.UTF_8));
        } else {
            liquibase.rollback(date, context);
        }
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return Joiner.on((char)',').join((Iterable)contexts);
    }
}

