/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.AbstractOutputStreamAppenderFactory;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="console")
public class ConsoleAppenderFactory<E extends DeferredProcessingAware>
extends AbstractOutputStreamAppenderFactory<E> {
    @NotNull
    private ConsoleStream target = ConsoleStream.STDOUT;

    @JsonProperty
    public ConsoleStream getTarget() {
        return this.target;
    }

    @JsonProperty
    public void setTarget(ConsoleStream target) {
        this.target = target;
    }

    @Override
    protected OutputStreamAppender<E> appender(LoggerContext context) {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("console-appender");
        appender.setContext((Context)context);
        appender.setTarget(this.target.get());
        return appender;
    }

    public static enum ConsoleStream {
        STDOUT("System.out"),
        STDERR("System.err");

        private final String value;

        private ConsoleStream(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }
    }
}

