/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.AbstractAppenderFactory;
import io.dropwizard.logging.async.AsyncAppenderFactory;
import io.dropwizard.logging.filter.LevelFilterFactory;
import io.dropwizard.logging.layout.LayoutFactory;
import io.dropwizard.util.Size;
import io.dropwizard.validation.ValidationMethod;
import javax.validation.constraints.Min;

@JsonTypeName(value="file")
public class FileAppenderFactory<E extends DeferredProcessingAware>
extends AbstractAppenderFactory<E> {
    private String currentLogFilename;
    private boolean archive = true;
    private String archivedLogFilenamePattern;
    @Min(value=0L)
    private int archivedFileCount = 5;
    private Size maxFileSize;

    @JsonProperty
    public String getCurrentLogFilename() {
        return this.currentLogFilename;
    }

    @JsonProperty
    public void setCurrentLogFilename(String currentLogFilename) {
        this.currentLogFilename = currentLogFilename;
    }

    @JsonProperty
    public boolean isArchive() {
        return this.archive;
    }

    @JsonProperty
    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    @JsonProperty
    public String getArchivedLogFilenamePattern() {
        return this.archivedLogFilenamePattern;
    }

    @JsonProperty
    public void setArchivedLogFilenamePattern(String archivedLogFilenamePattern) {
        this.archivedLogFilenamePattern = archivedLogFilenamePattern;
    }

    @JsonProperty
    public int getArchivedFileCount() {
        return this.archivedFileCount;
    }

    @JsonProperty
    public void setArchivedFileCount(int archivedFileCount) {
        this.archivedFileCount = archivedFileCount;
    }

    @JsonProperty
    public Size getMaxFileSize() {
        return this.maxFileSize;
    }

    @JsonProperty
    public void setMaxFileSize(Size maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @JsonIgnore
    @ValidationMethod(message="must have archivedLogFilenamePattern if archive is true")
    public boolean isValidArchiveConfiguration() {
        return !this.archive || this.archivedLogFilenamePattern != null;
    }

    @JsonIgnore
    @ValidationMethod(message="when specifying maxFileSize, archivedLogFilenamePattern must contain %i")
    public boolean isValidForMaxFileSizeSetting() {
        return !this.archive || this.maxFileSize == null || this.archivedLogFilenamePattern != null && this.archivedLogFilenamePattern.contains("%i");
    }

    @JsonIgnore
    @ValidationMethod(message="when archivedLogFilenamePattern contains %i, maxFileSize must be specified")
    public boolean isMaxFileSizeSettingSpecified() {
        return !this.archive || this.archivedLogFilenamePattern == null || !this.archivedLogFilenamePattern.contains("%i") || this.maxFileSize != null;
    }

    @JsonIgnore
    @ValidationMethod(message="currentLogFilename can only be null when archiving is enabled")
    public boolean isValidFileConfiguration() {
        return this.archive || this.currentLogFilename != null;
    }

    @Override
    public Appender<E> build(LoggerContext context, String applicationName, LayoutFactory<E> layoutFactory, LevelFilterFactory<E> levelFilterFactory, AsyncAppenderFactory<E> asyncAppenderFactory) {
        FileAppender appender = this.buildAppender(context);
        appender.setName("file-appender");
        appender.setAppend(true);
        appender.setContext((Context)context);
        LayoutWrappingEncoder layoutEncoder = new LayoutWrappingEncoder();
        layoutEncoder.setLayout(this.buildLayout(context, layoutFactory));
        appender.setEncoder((Encoder)layoutEncoder);
        appender.setPrudent(false);
        appender.addFilter(levelFilterFactory.build(this.threshold));
        this.getFilterFactories().stream().forEach(f -> appender.addFilter(f.build()));
        appender.start();
        return this.wrapAsync(appender, asyncAppenderFactory);
    }

    protected FileAppender<E> buildAppender(LoggerContext context) {
        if (this.archive) {
            DefaultTimeBasedFileNamingAndTriggeringPolicy triggeringPolicy;
            RollingFileAppender appender = new RollingFileAppender();
            appender.setFile(this.currentLogFilename);
            if (this.maxFileSize != null && !this.archivedLogFilenamePattern.contains("%d")) {
                FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
                SizeBasedTriggeringPolicy triggeringPolicy2 = new SizeBasedTriggeringPolicy();
                triggeringPolicy2.setMaxFileSize(String.valueOf(this.maxFileSize.toBytes()));
                triggeringPolicy2.setContext((Context)context);
                rollingPolicy.setContext((Context)context);
                rollingPolicy.setMaxIndex(this.getArchivedFileCount());
                rollingPolicy.setFileNamePattern(this.getArchivedLogFilenamePattern());
                appender.setRollingPolicy((RollingPolicy)rollingPolicy);
                appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy2);
                rollingPolicy.setParent((FileAppender)appender);
                rollingPolicy.start();
                return appender;
            }
            if (this.maxFileSize == null) {
                triggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
            } else {
                SizeAndTimeBasedFNATP maxFileSizeTriggeringPolicy = new SizeAndTimeBasedFNATP();
                maxFileSizeTriggeringPolicy.setMaxFileSize(String.valueOf(this.maxFileSize.toBytes()));
                triggeringPolicy = maxFileSizeTriggeringPolicy;
            }
            triggeringPolicy.setContext((Context)context);
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext((Context)context);
            rollingPolicy.setFileNamePattern(this.archivedLogFilenamePattern);
            rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
            triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
            rollingPolicy.setMaxHistory(this.archivedFileCount);
            appender.setRollingPolicy((RollingPolicy)rollingPolicy);
            appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
            rollingPolicy.setParent((FileAppender)appender);
            rollingPolicy.start();
            return appender;
        }
        FileAppender appender = new FileAppender();
        appender.setFile(this.currentLogFilename);
        return appender;
    }
}

