/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.util.StatusPrinter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.logback.InstrumentedAppender;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.DropwizardLayout;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggingFactory {
    @NotNull
    private Level level = Level.INFO;
    @NotNull
    private ImmutableMap<String, Level> loggers = ImmutableMap.of();
    @Valid
    @NotNull
    private ImmutableList<AppenderFactory> appenders = ImmutableList.of((Object)new ConsoleAppenderFactory());
    @JsonIgnore
    final LoggerContext loggerContext;
    @JsonIgnore
    final PrintStream configurationErrorsStream;

    public static void bootstrap() {
        LoggingFactory.bootstrap(Level.WARN);
    }

    public static void bootstrap(Level level) {
        LoggingFactory.hijackJDKLogging();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.detachAndStopAllAppenders();
        DropwizardLayout formatter = new DropwizardLayout(root.getLoggerContext(), TimeZone.getDefault());
        formatter.start();
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(level.toString());
        filter.start();
        ConsoleAppender appender = new ConsoleAppender();
        appender.addFilter((Filter)filter);
        appender.setContext((Context)root.getLoggerContext());
        LayoutWrappingEncoder layoutEncoder = new LayoutWrappingEncoder();
        layoutEncoder.setLayout((Layout)formatter);
        appender.setEncoder((Encoder)layoutEncoder);
        appender.start();
        root.addAppender((Appender)appender);
    }

    private static void hijackJDKLogging() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    public LoggingFactory() {
        this((LoggerContext)LoggerFactory.getILoggerFactory(), System.err);
    }

    @VisibleForTesting
    LoggingFactory(LoggerContext loggerContext, PrintStream configurationErrorsStream) {
        this.loggerContext = (LoggerContext)Preconditions.checkNotNull((Object)loggerContext);
        this.configurationErrorsStream = (PrintStream)Preconditions.checkNotNull((Object)configurationErrorsStream);
    }

    @JsonProperty
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty
    public void setLevel(Level level) {
        this.level = level;
    }

    @JsonProperty
    public ImmutableMap<String, Level> getLoggers() {
        return this.loggers;
    }

    @JsonProperty
    public void setLoggers(Map<String, Level> loggers) {
        this.loggers = ImmutableMap.copyOf(loggers);
    }

    @JsonProperty
    public ImmutableList<AppenderFactory> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory> appenders) {
        this.appenders = ImmutableList.copyOf(appenders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(MetricRegistry metricRegistry, String name) {
        LoggingFactory.hijackJDKLogging();
        Logger root = this.configureLevels();
        for (AppenderFactory output : this.appenders) {
            root.addAppender(output.build(this.loggerContext, name, null));
        }
        StatusPrinter.setPrintStream((PrintStream)this.configurationErrorsStream);
        try {
            StatusPrinter.printIfErrorsOccured((Context)this.loggerContext);
        }
        finally {
            StatusPrinter.setPrintStream((PrintStream)System.out);
        }
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("io.dropwizard:type=Logging");
            if (!server.isRegistered(objectName)) {
                server.registerMBean(new JMXConfigurator(this.loggerContext, server, objectName), objectName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
        this.configureInstrumentation(root, metricRegistry);
    }

    public void stop() {
        this.loggerContext.stop();
    }

    private void configureInstrumentation(Logger root, MetricRegistry metricRegistry) {
        InstrumentedAppender appender = new InstrumentedAppender(metricRegistry);
        appender.setContext((Context)this.loggerContext);
        appender.start();
        root.addAppender((Appender)appender);
    }

    private Logger configureLevels() {
        Logger root = this.loggerContext.getLogger("ROOT");
        this.loggerContext.reset();
        LevelChangePropagator propagator = new LevelChangePropagator();
        propagator.setContext((Context)this.loggerContext);
        propagator.setResetJUL(true);
        this.loggerContext.addListener((LoggerContextListener)propagator);
        root.setLevel(this.level);
        for (Map.Entry entry : this.loggers.entrySet()) {
            this.loggerContext.getLogger((String)entry.getKey()).setLevel((Level)entry.getValue());
        }
        return root;
    }
}

