/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.jetty.Jetty93InstrumentedConnectionFactory;
import io.dropwizard.jetty.SslReload;
import io.dropwizard.validation.ValidationMethod;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="https")
public class HttpsConnectorFactory
extends HttpConnectorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsConnectorFactory.class);
    private static final AtomicBoolean LOGGED = new AtomicBoolean(false);
    @Nullable
    private String keyStorePath;
    @Nullable
    private String keyStorePassword;
    @NotEmpty
    private String keyStoreType = "JKS";
    @Nullable
    private String keyStoreProvider;
    @Nullable
    private String trustStorePath;
    @Nullable
    private String trustStorePassword;
    @NotEmpty
    private String trustStoreType = "JKS";
    @Nullable
    private String trustStoreProvider;
    @Nullable
    private String keyManagerPassword;
    @Nullable
    private Boolean needClientAuth;
    @Nullable
    private Boolean wantClientAuth;
    @Nullable
    private String certAlias;
    @Nullable
    private File crlPath;
    @Nullable
    private Boolean enableCRLDP;
    @Nullable
    private Boolean enableOCSP;
    @Nullable
    private Integer maxCertPathLength;
    @Nullable
    private URI ocspResponderUrl;
    @Nullable
    private String jceProvider;
    private boolean validateCerts = false;
    private boolean validatePeers = false;
    @Nullable
    private List<String> supportedProtocols;
    @Nullable
    private List<String> excludedProtocols;
    @Nullable
    private List<String> supportedCipherSuites;
    @Nullable
    private List<String> excludedCipherSuites;
    private boolean allowRenegotiation = true;
    @Nullable
    private String endpointIdentificationAlgorithm;

    @JsonProperty
    public boolean getAllowRenegotiation() {
        return this.allowRenegotiation;
    }

    @JsonProperty
    public void setAllowRenegotiation(boolean allowRenegotiation) {
        this.allowRenegotiation = allowRenegotiation;
    }

    @JsonProperty
    @Nullable
    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    @JsonProperty
    public void setEndpointIdentificationAlgorithm(String endpointIdentificationAlgorithm) {
        this.endpointIdentificationAlgorithm = endpointIdentificationAlgorithm;
    }

    @JsonProperty
    @Nullable
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @JsonProperty
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @JsonProperty
    @Nullable
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonProperty
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @JsonProperty
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @JsonProperty
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @JsonProperty
    @Nullable
    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @JsonProperty
    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    @JsonProperty
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @JsonProperty
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @JsonProperty
    @Nullable
    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    @JsonProperty
    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    @JsonProperty
    @Nullable
    public String getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    @JsonProperty
    public void setKeyManagerPassword(String keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    @JsonProperty
    @Nullable
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @JsonProperty
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @JsonProperty
    @Nullable
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @JsonProperty
    public void setTrustStorePassword(@Nullable String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @JsonProperty
    @Nullable
    public Boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    @JsonProperty
    public void setNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    @JsonProperty
    @Nullable
    public Boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    @JsonProperty
    public void setWantClientAuth(Boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    @JsonProperty
    @Nullable
    public String getCertAlias() {
        return this.certAlias;
    }

    @JsonProperty
    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    @JsonProperty
    @Nullable
    public File getCrlPath() {
        return this.crlPath;
    }

    @JsonProperty
    public void setCrlPath(File crlPath) {
        this.crlPath = crlPath;
    }

    @JsonProperty
    @Nullable
    public Boolean getEnableCRLDP() {
        return this.enableCRLDP;
    }

    @JsonProperty
    public void setEnableCRLDP(Boolean enableCRLDP) {
        this.enableCRLDP = enableCRLDP;
    }

    @JsonProperty
    @Nullable
    public Boolean getEnableOCSP() {
        return this.enableOCSP;
    }

    @JsonProperty
    public void setEnableOCSP(Boolean enableOCSP) {
        this.enableOCSP = enableOCSP;
    }

    @JsonProperty
    @Nullable
    public Integer getMaxCertPathLength() {
        return this.maxCertPathLength;
    }

    @JsonProperty
    public void setMaxCertPathLength(Integer maxCertPathLength) {
        this.maxCertPathLength = maxCertPathLength;
    }

    @JsonProperty
    @Nullable
    public URI getOcspResponderUrl() {
        return this.ocspResponderUrl;
    }

    @JsonProperty
    public void setOcspResponderUrl(URI ocspResponderUrl) {
        this.ocspResponderUrl = ocspResponderUrl;
    }

    @JsonProperty
    @Nullable
    public String getJceProvider() {
        return this.jceProvider;
    }

    @JsonProperty
    public void setJceProvider(String jceProvider) {
        this.jceProvider = jceProvider;
    }

    @JsonProperty
    public boolean getValidatePeers() {
        return this.validatePeers;
    }

    @JsonProperty
    public void setValidatePeers(boolean validatePeers) {
        this.validatePeers = validatePeers;
    }

    @JsonProperty
    @Nullable
    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @JsonProperty
    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @JsonProperty
    @Nullable
    public List<String> getExcludedProtocols() {
        return this.excludedProtocols;
    }

    @JsonProperty
    public void setExcludedProtocols(List<String> excludedProtocols) {
        this.excludedProtocols = excludedProtocols;
    }

    @JsonProperty
    @Nullable
    public List<String> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    @JsonProperty
    @Nullable
    public List<String> getExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    @JsonProperty
    public void setExcludedCipherSuites(List<String> excludedCipherSuites) {
        this.excludedCipherSuites = excludedCipherSuites;
    }

    @JsonProperty
    public void setSupportedCipherSuites(List<String> supportedCipherSuites) {
        this.supportedCipherSuites = supportedCipherSuites;
    }

    @JsonProperty
    public boolean isValidateCerts() {
        return this.validateCerts;
    }

    @JsonProperty
    public void setValidateCerts(boolean validateCerts) {
        this.validateCerts = validateCerts;
    }

    @ValidationMethod(message="keyStorePath should not be null")
    public boolean isValidKeyStorePath() {
        return this.keyStoreType.startsWith("Windows-") || this.keyStorePath != null;
    }

    @ValidationMethod(message="keyStorePassword should not be null or empty")
    public boolean isValidKeyStorePassword() {
        return this.keyStoreType.startsWith("Windows-") || !Strings.isNullOrEmpty((String)this.keyStorePassword);
    }

    @Override
    public Connector build(Server server, MetricRegistry metrics, String name, @Nullable ThreadPool threadPool) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig);
        SslContextFactory sslContextFactory = this.configureSslContextFactory(new SslContextFactory());
        sslContextFactory.addLifeCycleListener((LifeCycle.Listener)this.logSslInfoOnStart(sslContextFactory));
        server.addBean((Object)sslContextFactory);
        server.addBean((Object)new SslReload(sslContextFactory, this::configureSslContextFactory));
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.toString());
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        return this.buildConnector(server, (Scheduler)scheduler, bufferPool, name, threadPool, new ConnectionFactory[]{new Jetty93InstrumentedConnectionFactory((ConnectionFactory)sslConnectionFactory, metrics.timer(this.httpConnections())), httpConnectionFactory});
    }

    @Override
    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration config = super.buildHttpConfiguration();
        config.setSecureScheme("https");
        config.setSecurePort(this.getPort());
        config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        return config;
    }

    protected AbstractLifeCycle.AbstractLifeCycleListener logSslInfoOnStart(final SslContextFactory sslContextFactory) {
        return new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarted(LifeCycle event) {
                HttpsConnectorFactory.this.logSupportedParameters(sslContextFactory.getSslContext());
            }
        };
    }

    private void logSupportedParameters(SSLContext context) {
        if (LOGGED.compareAndSet(false, true)) {
            Object[] protocols = context.getSupportedSSLParameters().getProtocols();
            SSLSocketFactory factory = context.getSocketFactory();
            Object[] cipherSuites = factory.getSupportedCipherSuites();
            LOGGER.info("Supported protocols: {}", (Object)Arrays.toString(protocols));
            LOGGER.info("Supported cipher suites: {}", (Object)Arrays.toString(cipherSuites));
            if (this.getSupportedProtocols() != null) {
                LOGGER.info("Configured protocols: {}", this.getSupportedProtocols());
            }
            if (this.getExcludedProtocols() != null) {
                LOGGER.info("Excluded protocols: {}", this.getExcludedProtocols());
            }
            if (this.getSupportedCipherSuites() != null) {
                LOGGER.info("Configured cipher suites: {}", this.getSupportedCipherSuites());
            }
            if (this.getExcludedCipherSuites() != null) {
                LOGGER.info("Excluded cipher suites: {}", this.getExcludedCipherSuites());
            }
        }
    }

    protected SslContextFactory configureSslContextFactory(SslContextFactory factory) {
        String trustStoreType;
        String keyStoreType;
        if (this.keyStorePath != null) {
            factory.setKeyStorePath(this.keyStorePath);
        }
        if ((keyStoreType = this.getKeyStoreType()).startsWith("Windows-")) {
            try {
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(null, null);
                factory.setKeyStore(keyStore);
            }
            catch (Exception e) {
                throw new IllegalStateException("Windows key store not supported", e);
            }
        } else {
            factory.setKeyStoreType(keyStoreType);
            factory.setKeyStorePassword(this.keyStorePassword);
        }
        if (this.keyStoreProvider != null) {
            factory.setKeyStoreProvider(this.keyStoreProvider);
        }
        if ((trustStoreType = this.getTrustStoreType()).startsWith("Windows-")) {
            try {
                KeyStore keyStore = KeyStore.getInstance(trustStoreType);
                keyStore.load(null, null);
                factory.setTrustStore(keyStore);
            }
            catch (Exception e) {
                throw new IllegalStateException("Windows key store not supported", e);
            }
        } else {
            if (this.trustStorePath != null) {
                factory.setTrustStorePath(this.trustStorePath);
            }
            if (this.trustStorePassword != null) {
                factory.setTrustStorePassword(this.trustStorePassword);
            }
            factory.setTrustStoreType(trustStoreType);
        }
        if (this.trustStoreProvider != null) {
            factory.setTrustStoreProvider(this.trustStoreProvider);
        }
        if (this.keyManagerPassword != null) {
            factory.setKeyManagerPassword(this.keyManagerPassword);
        }
        if (this.needClientAuth != null) {
            factory.setNeedClientAuth(this.needClientAuth.booleanValue());
        }
        if (this.wantClientAuth != null) {
            factory.setWantClientAuth(this.wantClientAuth.booleanValue());
        }
        if (this.certAlias != null) {
            factory.setCertAlias(this.certAlias);
        }
        if (this.crlPath != null) {
            factory.setCrlPath(this.crlPath.getAbsolutePath());
        }
        if (this.enableCRLDP != null) {
            factory.setEnableCRLDP(this.enableCRLDP.booleanValue());
        }
        if (this.enableOCSP != null) {
            factory.setEnableOCSP(this.enableOCSP.booleanValue());
        }
        if (this.maxCertPathLength != null) {
            factory.setMaxCertPathLength(this.maxCertPathLength.intValue());
        }
        if (this.ocspResponderUrl != null) {
            factory.setOcspResponderURL(this.ocspResponderUrl.toASCIIString());
        }
        if (this.jceProvider != null) {
            factory.setProvider(this.jceProvider);
        }
        factory.setRenegotiationAllowed(this.allowRenegotiation);
        factory.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
        factory.setValidateCerts(this.validateCerts);
        factory.setValidatePeerCerts(this.validatePeers);
        if (this.supportedProtocols != null) {
            factory.setIncludeProtocols((String[])Iterables.toArray(this.supportedProtocols, String.class));
        }
        if (this.excludedProtocols != null) {
            factory.setExcludeProtocols((String[])Iterables.toArray(this.excludedProtocols, String.class));
        }
        if (this.supportedCipherSuites != null) {
            factory.setIncludeCipherSuites((String[])Iterables.toArray(this.supportedCipherSuites, String.class));
        }
        if (this.excludedCipherSuites != null) {
            factory.setExcludeCipherSuites((String[])Iterables.toArray(this.excludedCipherSuites, String.class));
        }
        return factory;
    }
}

