/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.dropwizard.jetty.Slf4jRequestLog;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import java.util.TimeZone;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.eclipse.jetty.server.RequestLog;
import org.slf4j.LoggerFactory;

public class RequestLogFactory {
    @NotNull
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @Valid
    @NotNull
    private ImmutableList<AppenderFactory> appenders = ImmutableList.of((Object)new ConsoleAppenderFactory());

    @JsonProperty
    public ImmutableList<AppenderFactory> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(ImmutableList<AppenderFactory> appenders) {
        this.appenders = appenders;
    }

    @JsonProperty
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return !this.appenders.isEmpty();
    }

    public RequestLog build(String name) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"http.request");
        logger.setAdditive(false);
        LoggerContext context = logger.getLoggerContext();
        RequestLogLayout layout = new RequestLogLayout();
        layout.start();
        AppenderAttachableImpl attachable = new AppenderAttachableImpl();
        for (AppenderFactory output : this.appenders) {
            attachable.addAppender(output.build(context, name, (Layout)layout));
        }
        return new Slf4jRequestLog((AppenderAttachableImpl<ILoggingEvent>)attachable, this.timeZone);
    }

    private static class RequestLogLayout
    extends LayoutBase<ILoggingEvent> {
        private RequestLogLayout() {
        }

        public String doLayout(ILoggingEvent event) {
            return event.getFormattedMessage() + CoreConstants.LINE_SEPARATOR;
        }
    }
}

