/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import io.dropwizard.jackson.Discoverable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoverableSubtypeResolver
extends StdSubtypeResolver {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DiscoverableSubtypeResolver.class);
    private final List<Class<?>> discoveredSubtypes;

    public DiscoverableSubtypeResolver() {
        this(Discoverable.class);
    }

    public DiscoverableSubtypeResolver(Class<?> rootKlass) {
        ArrayList subtypes = new ArrayList();
        for (Class<?> klass : this.discoverServices(rootKlass)) {
            for (Class<?> subtype : this.discoverServices(klass)) {
                subtypes.add(subtype);
                this.registerSubtypes(new Class[]{subtype});
            }
        }
        this.discoveredSubtypes = subtypes;
    }

    public List<Class<?>> getDiscoveredSubtypes() {
        return this.discoveredSubtypes;
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    protected List<Class<?>> discoverServices(Class<?> klass) {
        ArrayList serviceClasses = new ArrayList();
        try {
            Enumeration<URL> resources = this.getClassLoader().getResources("META-INF/services/" + klass.getName());
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream input = url.openStream();
                Throwable throwable = null;
                try (InputStreamReader streamReader = new InputStreamReader(input, StandardCharsets.UTF_8);
                     BufferedReader reader = new BufferedReader(streamReader);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Class<?> loadedClass = this.loadClass(line);
                        if (loadedClass == null) continue;
                        serviceClasses.add(loadedClass);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    DiscoverableSubtypeResolver.$closeResource(throwable, input);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load META-INF/services/{}", (Object)klass.getName(), (Object)e);
        }
        return serviceClasses;
    }

    @Nullable
    private Class<?> loadClass(String line) {
        try {
            return this.getClassLoader().loadClass(line.trim());
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Unable to load {}", (Object)line);
            return null;
        }
    }
}

