/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client.proxy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.jspecify.annotations.Nullable;

public class NonProxyListProxyRoutePlanner
extends DefaultProxyRoutePlanner {
    private static final Pattern WILDCARD = Pattern.compile("\\*");
    private static final String REGEX_WILDCARD = ".*";
    private List<Pattern> nonProxyHostPatterns;

    public NonProxyListProxyRoutePlanner(HttpHost proxy, @Nullable List<String> nonProxyHosts) {
        super(proxy, null);
        this.nonProxyHostPatterns = this.getNonProxyHostPatterns(nonProxyHosts);
    }

    public NonProxyListProxyRoutePlanner(HttpHost proxy, SchemePortResolver schemePortResolver, @Nullable List<String> nonProxyHosts) {
        super(proxy, schemePortResolver);
        this.nonProxyHostPatterns = this.getNonProxyHostPatterns(nonProxyHosts);
    }

    private List<Pattern> getNonProxyHostPatterns(@Nullable List<String> nonProxyHosts) {
        if (nonProxyHosts == null) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(nonProxyHosts.size());
        for (String nonProxyHost : nonProxyHosts) {
            patterns.add(Pattern.compile(WILDCARD.matcher(nonProxyHost).replaceAll(REGEX_WILDCARD)));
        }
        return Collections.unmodifiableList(patterns);
    }

    protected List<Pattern> getNonProxyHostPatterns() {
        return this.nonProxyHostPatterns;
    }

    protected @Nullable HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
        for (Pattern nonProxyHostPattern : this.nonProxyHostPatterns) {
            if (!nonProxyHostPattern.matcher(target.getHostName()).matches()) continue;
            return null;
        }
        return super.determineProxy(target, context);
    }
}

