/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import io.dropwizard.client.ssl.TlsConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLInitializationException;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardSSLConnectionSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(DropwizardSSLConnectionSocketFactory.class);
    private final TlsConfiguration configuration;
    final @Nullable HostnameVerifier verifier;

    public DropwizardSSLConnectionSocketFactory(TlsConfiguration configuration) {
        this(configuration, null);
    }

    public DropwizardSSLConnectionSocketFactory(TlsConfiguration configuration, @Nullable HostnameVerifier verifier) {
        this.configuration = configuration;
        this.verifier = verifier;
    }

    public SSLConnectionSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory(this.buildSslContext(), this.getSupportedProtocols(), this.getSupportedCiphers(), this.chooseHostnameVerifier());
    }

    private @Nullable String @Nullable [] getSupportedCiphers() {
        List<String> supportedCiphers = this.configuration.getSupportedCiphers();
        if (supportedCiphers == null) {
            return null;
        }
        return supportedCiphers.toArray(new String[0]);
    }

    private @Nullable String @Nullable [] getSupportedProtocols() {
        List<String> supportedProtocols = this.configuration.getSupportedProtocols();
        if (supportedProtocols == null) {
            return null;
        }
        return supportedProtocols.toArray(new String[0]);
    }

    private HostnameVerifier chooseHostnameVerifier() {
        if (this.configuration.isVerifyHostname()) {
            return this.verifier != null ? this.verifier : new DefaultHostnameVerifier();
        }
        return new NoopHostnameVerifier();
    }

    private SSLContext buildSslContext() throws SSLInitializationException {
        SSLContext sslContext;
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.setProtocol(this.configuration.getProtocol());
            String configuredProvider = this.configuration.getProvider();
            if (configuredProvider != null) {
                sslContextBuilder.setProvider(configuredProvider);
            }
            this.loadKeyMaterial(sslContextBuilder);
            this.loadTrustMaterial(sslContextBuilder);
            sslContext = sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new SSLInitializationException(e.getMessage(), (Throwable)e);
        }
        return sslContext;
    }

    private @Nullable PrivateKeyStrategy choosePrivateKeyStrategy() {
        PrivateKeyStrategy privateKeyStrategy = null;
        if (this.configuration.getCertAlias() != null) {
            privateKeyStrategy = (aliases, socket) -> this.configuration.getCertAlias();
        }
        return privateKeyStrategy;
    }

    private void loadKeyMaterial(SSLContextBuilder sslContextBuilder) throws Exception {
        if (this.configuration.getKeyStorePath() != null) {
            KeyStore keystore = DropwizardSSLConnectionSocketFactory.loadKeyStore(this.configuration.getKeyStoreType(), this.configuration.getKeyStorePath(), Objects.requireNonNull(this.configuration.getKeyStorePassword()), this.configuration.getKeyStoreProvider());
            sslContextBuilder.loadKeyMaterial(keystore, Objects.requireNonNull(this.configuration.getKeyStorePassword()).toCharArray(), this.choosePrivateKeyStrategy());
        }
    }

    private void loadTrustMaterial(SSLContextBuilder sslContextBuilder) throws Exception {
        KeyStore trustStore = null;
        if (this.configuration.getTrustStorePath() != null) {
            trustStore = DropwizardSSLConnectionSocketFactory.loadKeyStore(this.configuration.getTrustStoreType(), this.configuration.getTrustStorePath(), Objects.requireNonNull(this.configuration.getTrustStorePassword()), this.configuration.getTrustStoreProvider());
        }
        TrustSelfSignedStrategy trustStrategy = null;
        if (this.configuration.isTrustSelfSignedCertificates()) {
            trustStrategy = new TrustSelfSignedStrategy();
        }
        sslContextBuilder.loadTrustMaterial(trustStore, (TrustStrategy)trustStrategy);
    }

    private static KeyStore loadKeyStore(String type, File path, String password, @Nullable String provider) throws Exception {
        KeyStore keyStore;
        if (provider == null) {
            keyStore = KeyStore.getInstance(type);
        } else {
            try {
                keyStore = KeyStore.getInstance(type, provider);
            }
            catch (KeyStoreException ignore) {
                log.warn("Keystore of type: {} is not supported for provider: {}. Trying out other providers...", (Object)type, (Object)provider);
                keyStore = KeyStore.getInstance(type);
            }
        }
        try (FileInputStream inputStream = new FileInputStream(path);){
            keyStore.load(inputStream, password.toCharArray());
        }
        return keyStore;
    }
}

