/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.client.HttpClientConfiguration;
import io.dropwizard.validation.ValidationMethod;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;

public class JerseyClientConfiguration
extends HttpClientConfiguration {
    @Min(value=1L)
    @Max(value=16384L)
    private @Min(value=1L) @Max(value=16384L) int minThreads = 1;
    @Min(value=1L)
    @Max(value=16384L)
    private @Min(value=1L) @Max(value=16384L) int maxThreads = 128;
    @Min(value=1L)
    @Max(value=16384L)
    private @Min(value=1L) @Max(value=16384L) int workQueueSize = 8;
    private boolean gzipEnabled = true;
    private boolean gzipEnabledForRequests = true;
    private boolean chunkedEncodingEnabled = true;

    @JsonProperty
    public int getMinThreads() {
        return this.minThreads;
    }

    @JsonProperty
    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    @JsonProperty
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty
    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    @JsonProperty
    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    @JsonProperty
    public void setGzipEnabled(boolean enabled) {
        this.gzipEnabled = enabled;
    }

    @JsonProperty
    public boolean isGzipEnabledForRequests() {
        return this.gzipEnabledForRequests;
    }

    @JsonProperty
    public void setGzipEnabledForRequests(boolean enabled) {
        this.gzipEnabledForRequests = enabled;
    }

    @JsonProperty
    public boolean isChunkedEncodingEnabled() {
        return this.chunkedEncodingEnabled;
    }

    @JsonProperty
    public void setChunkedEncodingEnabled(boolean chunkedEncodingEnabled) {
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
    }

    @JsonProperty
    public int getWorkQueueSize() {
        return this.workQueueSize;
    }

    @JsonProperty
    public void setWorkQueueSize(int workQueueSize) {
        this.workQueueSize = workQueueSize;
    }

    @JsonIgnore
    @ValidationMethod(message=".minThreads must be less than or equal to maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @JsonIgnore
    @ValidationMethod(message=".gzipEnabledForRequests requires gzipEnabled set to true")
    public boolean isCompressionConfigurationValid() {
        return !this.gzipEnabledForRequests || this.gzipEnabled;
    }
}

