/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.client;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.InstrumentedClientConnManager;
import com.codahale.metrics.httpclient.InstrumentedHttpClient;
import io.dropwizard.client.HttpClientConfiguration;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientBuilder {
    private static final HttpRequestRetryHandler NO_RETRIES = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    };
    private final MetricRegistry metricRegistry;
    private String environmentName;
    private HttpClientConfiguration configuration = new HttpClientConfiguration();
    private DnsResolver resolver = new SystemDefaultDnsResolver();
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private SchemeRegistry registry = SchemeRegistryFactory.createSystemDefault();
    private CredentialsProvider credentialsProvider = null;

    public HttpClientBuilder(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public HttpClientBuilder(Environment environment) {
        this(environment.metrics());
        this.name(environment.getName());
    }

    public HttpClientBuilder name(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public HttpClientBuilder using(HttpClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClientBuilder using(DnsResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public HttpClientBuilder using(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
        return this;
    }

    public HttpClientBuilder using(SchemeRegistry registry) {
        this.registry = registry;
        return this;
    }

    public HttpClientBuilder using(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public HttpClient build(String name) {
        BasicHttpParams params = this.createHttpParams(name);
        InstrumentedClientConnManager manager = this.createConnectionManager(this.registry, name);
        InstrumentedHttpClient client = new InstrumentedHttpClient(this.metricRegistry, manager, (HttpParams)params, name);
        this.setStrategiesForClient(client);
        return client;
    }

    protected void setStrategiesForClient(InstrumentedHttpClient client) {
        final long keepAlive = this.configuration.getKeepAlive().toMilliseconds();
        if (keepAlive == 0L) {
            client.setReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        } else {
            client.setReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            client.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    return duration == -1L ? keepAlive : duration;
                }
            });
        }
        if (this.configuration.getRetries() == 0) {
            client.setHttpRequestRetryHandler(NO_RETRIES);
        } else if (this.httpRequestRetryHandler != null) {
            client.setHttpRequestRetryHandler(this.httpRequestRetryHandler);
        } else {
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.configuration.getRetries(), false));
        }
        if (this.credentialsProvider != null) {
            client.setCredentialsProvider(this.credentialsProvider);
        }
    }

    protected BasicHttpParams createHttpParams(String name) {
        BasicHttpParams params = new BasicHttpParams();
        if (this.configuration.isCookiesEnabled()) {
            params.setParameter("http.protocol.cookie-policy", (Object)"best-match");
        } else {
            params.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        }
        params.setParameter("http.useragent", (Object)this.createUserAgent(name));
        Integer timeout = (int)this.configuration.getTimeout().toMilliseconds();
        params.setParameter("http.socket.timeout", (Object)timeout);
        Integer connectionTimeout = (int)this.configuration.getConnectionTimeout().toMilliseconds();
        params.setParameter("http.connection.timeout", (Object)connectionTimeout);
        params.setParameter("http.tcp.nodelay", (Object)Boolean.TRUE);
        params.setParameter("http.connection.stalecheck", (Object)Boolean.FALSE);
        return params;
    }

    protected String createUserAgent(String name) {
        String defaultUserAgent = this.environmentName == null ? name : String.format("%s (%s)", this.environmentName, name);
        return (String)this.configuration.getUserAgent().or((Object)defaultUserAgent);
    }

    protected InstrumentedClientConnManager createConnectionManager(SchemeRegistry registry, String name) {
        Duration ttl = this.configuration.getTimeToLive();
        InstrumentedClientConnManager manager = new InstrumentedClientConnManager(this.metricRegistry, registry, ttl.getQuantity(), ttl.getUnit(), this.resolver, name);
        manager.setDefaultMaxPerRoute(this.configuration.getMaxConnectionsPerRoute());
        manager.setMaxTotal(this.configuration.getMaxConnections());
        return manager;
    }
}

