/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.PathDualValueOperation;
import com.github.fge.jsonpatch.operation.policy.PathMissingPolicy;
import com.google.common.base.Equivalence;
import com.google.common.collect.Iterables;

public abstract class TranslateOperationBase
extends PathDualValueOperation {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();
    private PathMissingPolicy pathMissingPolicy;

    public TranslateOperationBase(String op, JsonPointer path, JsonNode fromValue, JsonNode toValue, PathMissingPolicy pathMissingPolicy) {
        super(op, path, fromValue, toValue);
        this.pathMissingPolicy = pathMissingPolicy;
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode ret = node.deepCopy();
        JsonNode toValueRet = this.toValue.deepCopy();
        if (this.getPath().isEmpty()) {
            if (EQUIVALENCE.equivalent((Object)ret, (Object)this.fromValue)) {
                return toValueRet;
            }
            return ret;
        }
        JsonNode valueAtPath = (JsonNode)this.getPath().path((TreeNode)ret);
        if (valueAtPath.isMissingNode()) {
            switch (this.pathMissingPolicy) {
                case THROW: {
                    throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
                }
                case SKIP: {
                    return ret;
                }
            }
        }
        if (EQUIVALENCE.equivalent((Object)valueAtPath, (Object)this.fromValue)) {
            JsonNode parent = (JsonNode)this.getPath().parent().get((TreeNode)ret);
            String rawToken = ((TokenResolver)Iterables.getLast((Iterable)this.getPath())).getToken().getRaw();
            if (parent.isObject()) {
                ((ObjectNode)parent).set(rawToken, toValueRet);
            } else {
                ((ArrayNode)parent).set(Integer.parseInt(rawToken), toValueRet);
            }
        }
        return ret;
    }
}

