/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.operation.PathValueOperation;
import com.google.common.base.Equivalence;

public final class TestOperation
extends PathValueOperation {
    public static final String OPERATION_NAME = "test";
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    @JsonCreator
    public TestOperation(@JsonProperty(value="path") JsonPointer path, @JsonProperty(value="value") JsonNode value) {
        super(OPERATION_NAME, path, value);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode tested = (JsonNode)this.getPath().path((TreeNode)node);
        if (tested.isMissingNode()) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
        }
        if (!EQUIVALENCE.equivalent((Object)tested, (Object)this.value)) {
            throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.valueTestFailure"));
        }
        return node.deepCopy();
    }
}

