/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jackson.jsonpointer.TokenResolver;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperationBase;
import com.github.fge.jsonpatch.operation.policy.PathMissingPolicy;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import com.google.common.collect.Iterables;
import java.io.IOException;

public abstract class RemoveOperationBase
extends JsonPatchOperationBase {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);

    @JsonCreator
    public RemoveOperationBase(String op, @JsonProperty(value="path") JsonPointer path, PathMissingPolicy pathMissingPolicy) {
        super(op, path, pathMissingPolicy);
    }

    @Override
    public JsonNode apply(JsonNode node) throws JsonPatchException {
        JsonNode ret = node.deepCopy();
        if (this.getPath().isEmpty()) {
            return MissingNode.getInstance();
        }
        if (((JsonNode)this.getPath().path((TreeNode)node)).isMissingNode()) {
            switch (this.getPathMissingPolicy()) {
                case THROW: {
                    throw new JsonPatchException(BUNDLE.getMessage("jsonPatch.noSuchPath"));
                }
                case SKIP: {
                    return ret;
                }
            }
        }
        JsonNode parentNode = (JsonNode)this.getPath().parent().get((TreeNode)ret);
        String raw = ((TokenResolver)Iterables.getLast((Iterable)this.getPath())).getToken().getRaw();
        if (parentNode.isObject()) {
            ((ObjectNode)parentNode).remove(raw);
        } else {
            ((ArrayNode)parentNode).remove(Integer.parseInt(raw));
        }
        return ret;
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("op", this.getOp());
        jgen.writeStringField("path", this.getPath().toString());
        jgen.writeEndObject();
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        this.serialize(jgen, provider);
    }

    @Override
    public String toString() {
        return "op: " + this.getOp() + "; path: \"" + this.getPath() + '\"';
    }
}

