/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperationBase;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;

public abstract class PathDualValueOperation
extends JsonPatchOperationBase {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    @JsonSerialize
    protected final JsonNode fromValue;
    @JsonSerialize
    protected final JsonNode toValue;

    protected PathDualValueOperation(String op, JsonPointer path, JsonNode fromValue, JsonNode toValue) {
        super(op, path);
        this.fromValue = fromValue;
        this.toValue = toValue;
    }

    public final void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", this.getOp());
        jgen.writeStringField("path", this.getPath().toString());
        jgen.writeFieldName("from");
        jgen.writeTree((TreeNode)this.fromValue);
        jgen.writeFieldName("value");
        jgen.writeTree((TreeNode)this.toValue);
        jgen.writeEndObject();
    }

    public final void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public final String toString() {
        return "op: " + this.getOp() + "; path: \"" + this.getPath() + "\"; from: " + this.fromValue + "; value: " + this.toValue;
    }
}

