/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.utils;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.internal.util.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;

@Evolving
public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    @Override
    public boolean hasNext();

    @Override
    public T next();

    default public <U> CloseableIterator<U> map(final Function<T, U> function) {
        final CloseableIterator closeableIterator = this;
        return new CloseableIterator<U>(){

            @Override
            public void remove() {
                closeableIterator.remove();
            }

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public U next() {
                return function.apply(closeableIterator.next());
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }

    default public CloseableIterator<T> filter(Function<T, Boolean> function) {
        return this.breakableFilter(object -> {
            if (((Boolean)function.apply(object)).booleanValue()) {
                return BreakableFilterResult.INCLUDE;
            }
            return BreakableFilterResult.EXCLUDE;
        });
    }

    default public CloseableIterator<T> takeWhile(Function<T, Boolean> function) {
        return this.breakableFilter(object -> {
            if (((Boolean)function.apply(object)).booleanValue()) {
                return BreakableFilterResult.INCLUDE;
            }
            return BreakableFilterResult.BREAK;
        });
    }

    default public CloseableIterator<T> breakableFilter(final Function<T, BreakableFilterResult> function) {
        final CloseableIterator closeableIterator = this;
        return new CloseableIterator<T>(){
            T next;
            boolean hasLoadedNext;
            boolean shouldBreak = false;

            @Override
            public boolean hasNext() {
                if (this.shouldBreak) {
                    return false;
                }
                if (this.hasLoadedNext) {
                    return true;
                }
                while (closeableIterator.hasNext()) {
                    Object t = closeableIterator.next();
                    BreakableFilterResult breakableFilterResult = (BreakableFilterResult)((Object)function.apply(t));
                    if (breakableFilterResult == BreakableFilterResult.INCLUDE) {
                        this.next = t;
                        this.hasLoadedNext = true;
                        return true;
                    }
                    if (breakableFilterResult != BreakableFilterResult.BREAK) continue;
                    this.shouldBreak = true;
                    return false;
                }
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasLoadedNext = false;
                return this.next;
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }

    default public CloseableIterator<T> combine(final CloseableIterator<T> closeableIterator) {
        final CloseableIterator closeableIterator2 = this;
        return new CloseableIterator<T>(){

            @Override
            public boolean hasNext() {
                return closeableIterator2.hasNext() || closeableIterator.hasNext();
            }

            @Override
            public T next() {
                if (closeableIterator2.hasNext()) {
                    return closeableIterator2.next();
                }
                return closeableIterator.next();
            }

            @Override
            public void close() throws IOException {
                Utils.closeCloseables(closeableIterator2, closeableIterator);
            }
        };
    }

    default public List<T> toInMemoryList() {
        ArrayList<T> arrayList = new ArrayList<T>();
        try (CloseableIterator closeableIterator = this;){
            while (closeableIterator.hasNext()) {
                arrayList.add(closeableIterator.next());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to close the CloseableIterator", iOException);
        }
        return arrayList;
    }

    public static enum BreakableFilterResult {
        INCLUDE,
        EXCLUDE,
        BREAK;

    }
}

