/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.skipping.StatsSchemaHelper;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaChanges;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SchemaUtils {
    private SchemaUtils() {
    }

    public static void validateSchema(StructType structType, boolean bl) {
        Preconditions.checkArgument(structType.length() > 0, "Schema should contain at least one column");
        List<String> list = SchemaUtils.flattenNestedFieldNames(structType);
        Set set = list.stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (set.size() != list.size()) {
            HashSet hashSet = new HashSet();
            List<String> list2 = list.stream().map(String::toLowerCase).filter(string -> !hashSet.add(string)).collect(Collectors.toList());
            throw DeltaErrors.duplicateColumnsInSchema(structType, list2);
        }
        if (!bl) {
            SchemaUtils.validParquetColumnNames(list);
        } else {
            list.forEach(string -> {
                if (string.contains("\\n")) {
                    throw DeltaErrors.invalidColumnName(string, "\\n");
                }
            });
        }
        SchemaUtils.validateSupportedType(structType);
    }

    public static void validateUpdatedSchema(Metadata metadata, Metadata metadata2, Set<String> set, boolean bl) {
        Preconditions.checkArgument(ColumnMapping.isColumnMappingModeEnabled(ColumnMapping.getColumnMappingMode(metadata2.getConfiguration())), "Cannot validate updated schema when column mapping is disabled");
        SchemaUtils.validateSchema(metadata2.getSchema(), true);
        SchemaUtils.validatePartitionColumns(metadata2.getSchema(), new ArrayList<String>(metadata2.getPartitionColNames()));
        int n = Integer.parseInt(metadata.getConfiguration().getOrDefault("delta.columnMapping.maxColumnId", "0"));
        SchemaUtils.validateSchemaEvolution(metadata.getSchema(), metadata2.getSchema(), ColumnMapping.getColumnMappingMode(metadata2.getConfiguration()), set, n, bl, TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.fromMetadata(metadata2.getConfiguration()));
    }

    public static void validatePartitionColumns(StructType structType, List<String> list) {
        Map<String, DataType> map = structType.fields().stream().collect(Collectors.toMap(structField -> structField.getName().toLowerCase(Locale.ROOT), StructField::getDataType));
        list.stream().forEach(string -> {
            DataType dataType = (DataType)map.get(string.toLowerCase(Locale.ROOT));
            Preconditions.checkArgument(dataType != null, "Partition column %s not found in the schema", string);
            if (!(dataType instanceof BooleanType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType || dataType instanceof StringType || dataType instanceof BinaryType || dataType instanceof DateType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType)) {
                throw DeltaErrors.unsupportedPartitionDataType(string, dataType);
            }
        });
    }

    public static List<String> casePreservingPartitionColNames(StructType structType, List<String> list) {
        HashMap hashMap = new HashMap();
        structType.fieldNames().forEach(string -> hashMap.put(string.toLowerCase(Locale.ROOT), string));
        return list.stream().map(string -> (String)hashMap.get(string.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    public static Map<String, Literal> casePreservingPartitionColNames(List<String> list, Map<String, Literal> map) {
        HashMap hashMap = new HashMap();
        list.forEach(string -> hashMap.put(string.toLowerCase(Locale.ROOT), string));
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (String)hashMap.get(((String)entry.getKey()).toLowerCase(Locale.ROOT)), Map.Entry::getValue));
    }

    public static List<Column> casePreservingEligibleClusterColumns(StructType structType, List<Column> list) {
        List list2 = list.stream().map(column -> ColumnMapping.getPhysicalColumnNameAndDataType(structType, column)).collect(Collectors.toList());
        List list3 = list2.stream().filter(tuple2 -> !StatsSchemaHelper.isSkippingEligibleDataType((DataType)tuple2._2)).map(tuple2 -> ((Column)tuple2._1).toString() + " : " + tuple2._2).collect(Collectors.toList());
        if (!list3.isEmpty()) {
            throw new KernelException(String.format("Clustering is not supported because the following column(s): %s don't support data skipping", list3));
        }
        return list2.stream().map(tuple2 -> (Column)tuple2._1).collect(Collectors.toList());
    }

    public static int findColIndex(StructType structType, String string) {
        for (int i = 0; i < structType.length(); ++i) {
            if (!structType.at(i).getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static List<Tuple2<List<String>, StructField>> filterRecursively(DataType dataType, boolean bl, boolean bl2, Function<StructField, Boolean> function) {
        return SchemaUtils.recurseIntoComplexTypes(dataType, new ArrayList<String>(), bl, bl2, function);
    }

    public static List<Column> collectLeafColumns(StructType structType, Set<String> set, int n) {
        ArrayList<Column> arrayList = new ArrayList<Column>();
        SchemaUtils.collectLeafColumnsInternal(structType, null, set, arrayList, n);
        return arrayList;
    }

    public static String concatWithDot(List<String> list) {
        return list.stream().map(SchemaUtils::escapeDots).collect(Collectors.joining("."));
    }

    private static List<String> flattenNestedFieldNames(StructType structType) {
        List<Tuple2<List<String>, StructField>> list = SchemaUtils.filterRecursively(structType, true, false, structField -> true);
        return list.stream().map(tuple2 -> (List)tuple2._1).map(SchemaUtils::concatWithDot).collect(Collectors.toList());
    }

    private static List<Tuple2<List<String>, StructField>> recurseIntoComplexTypes(DataType dataType, List<String> list, boolean bl, boolean bl2, Function<StructField, Boolean> function) {
        ArrayList<Tuple2<List<String>, StructField>> arrayList = new ArrayList<Tuple2<List<String>, StructField>>();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            for (StructField structField : structType.fields()) {
                ArrayList<String> arrayList2 = new ArrayList<String>(list);
                arrayList2.add(structField.getName());
                if (function.apply(structField).booleanValue()) {
                    arrayList.add(new Tuple2<ArrayList<String>, StructField>(arrayList2, structField));
                    if (bl2) {
                        return arrayList;
                    }
                }
                arrayList.addAll(SchemaUtils.recurseIntoComplexTypes(structField.getDataType(), arrayList2, bl, bl2, function));
                if (!bl2 || arrayList.isEmpty()) continue;
                return arrayList;
            }
        } else {
            if (dataType instanceof ArrayType && bl) {
                ArrayType arrayType = (ArrayType)dataType;
                ArrayList<String> arrayList3 = new ArrayList<String>(list);
                arrayList3.add("element");
                return SchemaUtils.recurseIntoComplexTypes(arrayType.getElementType(), arrayList3, bl, bl2, function);
            }
            if (dataType instanceof MapType && bl) {
                MapType mapType = (MapType)dataType;
                ArrayList<String> arrayList4 = new ArrayList<String>(list);
                arrayList4.add("key");
                ArrayList<String> arrayList5 = new ArrayList<String>(list);
                arrayList5.add("value");
                arrayList.addAll(SchemaUtils.recurseIntoComplexTypes(mapType.getKeyType(), arrayList4, bl, bl2, function));
                if (bl2 && !arrayList.isEmpty()) {
                    return arrayList;
                }
                arrayList.addAll(SchemaUtils.recurseIntoComplexTypes(mapType.getValueType(), arrayList5, bl, bl2, function));
            }
        }
        return arrayList;
    }

    static SchemaChanges computeSchemaChangesById(Map<Integer, StructField> map, Map<Integer, StructField> map2) {
        SchemaChanges.Builder builder = SchemaChanges.builder();
        for (Map.Entry<Integer, StructField> entry : map2.entrySet()) {
            StructField structField = map.get(entry.getKey());
            StructField structField2 = entry.getValue();
            if (structField == null) {
                builder.withAddedField(structField2);
                continue;
            }
            if (structField.equals(structField2)) continue;
            builder.withUpdatedField(structField, structField2);
        }
        for (Map.Entry<Integer, StructField> entry : map.entrySet()) {
            if (map2.containsKey(entry.getKey())) continue;
            builder.withRemovedField(entry.getValue());
        }
        return builder.build();
    }

    private static void validatePhysicalNameConsistency(List<Tuple2<StructField, StructField>> list) {
        for (Tuple2<StructField, StructField> tuple2 : list) {
            StructField structField = (StructField)tuple2._1;
            StructField structField2 = (StructField)tuple2._2;
            if (ColumnMapping.getPhysicalName(structField).equals(ColumnMapping.getPhysicalName(structField2))) continue;
            throw new IllegalArgumentException(String.format("Existing field with id %s in current schema has physical name %s which is different from %s", ColumnMapping.getColumnId(structField), ColumnMapping.getPhysicalName(structField), ColumnMapping.getPhysicalName(structField2)));
        }
    }

    private static void validateSchemaEvolution(StructType structType, StructType structType2, ColumnMapping.ColumnMappingMode columnMappingMode, Set<String> set, int n, boolean bl, boolean bl2) {
        switch (columnMappingMode) {
            case ID: 
            case NAME: {
                SchemaUtils.validateSchemaEvolutionById(structType, structType2, set, n, bl, bl2);
                return;
            }
            case NONE: {
                throw new UnsupportedOperationException("Schema evolution without column mapping is not supported");
            }
        }
        throw new UnsupportedOperationException("Unknown column mapping mode: " + (Object)((Object)columnMappingMode));
    }

    private static void validateSchemaEvolutionById(StructType structType, StructType structType2, Set<String> set, int n, boolean bl, boolean bl2) {
        Map<Integer, StructField> map = SchemaUtils.fieldsById(structType);
        Map<Integer, StructField> map2 = SchemaUtils.fieldsById(structType2);
        SchemaChanges schemaChanges = SchemaUtils.computeSchemaChangesById(map, map2);
        SchemaUtils.validatePhysicalNameConsistency(schemaChanges.updatedFields());
        SchemaUtils.validateUpdatedSchemaCompatibility(schemaChanges, n, bl, bl2);
        SchemaUtils.validateClusteringColumnsNotDropped(schemaChanges.removedFields(), set);
    }

    private static void validateClusteringColumnsNotDropped(List<StructField> list, Set<String> set) {
        for (StructField structField : list) {
            if (!set.contains(ColumnMapping.getPhysicalName(structField))) continue;
            throw new KernelException(String.format("Cannot drop clustering column %s", structField.getName()));
        }
    }

    private static void validateUpdatedSchemaCompatibility(SchemaChanges schemaChanges, int n, boolean bl, boolean bl2) {
        for (StructField object : schemaChanges.addedFields()) {
            if (!bl && !object.isNullable()) {
                throw new KernelException(String.format("Cannot add non-nullable field %s", object.getName()));
            }
            int n2 = ColumnMapping.getColumnId(object);
            if (n2 > n) continue;
            throw new IllegalArgumentException(String.format("Cannot add a new column with a fieldId <= maxFieldId. Found field: %s withfieldId=%s. Current maxFieldId in the table is: %s", object, n2, n));
        }
        for (Tuple2 tuple2 : schemaChanges.updatedFields()) {
            SchemaUtils.validateFieldCompatibility((StructField)tuple2._1, (StructField)tuple2._2, bl2);
        }
    }

    private static void validateFieldCompatibility(StructField structField, StructField structField2, boolean bl) {
        if (structField.isNullable() && !structField2.isNullable()) {
            throw new KernelException(String.format("Cannot tighten the nullability of existing field %s", structField.getName()));
        }
        if (structField.getDataType() instanceof StructType && structField2.getDataType() instanceof StructType) {
            StructType structType = (StructType)structField.getDataType();
            StructType structType2 = (StructType)structField2.getDataType();
            Map map = structType.fields().stream().collect(Collectors.toMap(ColumnMapping::getColumnId, Function.identity()));
            for (StructField structField3 : structType2.fields()) {
                StructField structField4 = (StructField)map.get(ColumnMapping.getColumnId(structField3));
                if (structField4 == null) continue;
                SchemaUtils.validateFieldCompatibility(structField4, structField3, bl);
            }
        } else if (structField.getDataType() instanceof MapType && structField2.getDataType() instanceof MapType) {
            StructType structType;
            StructType structType3;
            MapType mapType = (MapType)structField.getDataType();
            MapType mapType2 = (MapType)structField2.getDataType();
            if (bl && mapType.getKeyType() instanceof StructType && mapType2.getKeyType() instanceof StructType && !(structType3 = (StructType)mapType.getKeyType()).equals(structType = (StructType)mapType2.getKeyType())) {
                throw new KernelException(String.format("Cannot change the type key of Map field %s from %s to %s", structField2.getName(), structType3, structType));
            }
            SchemaUtils.validateFieldCompatibility(mapType.getKeyField(), mapType2.getKeyField(), bl);
            SchemaUtils.validateFieldCompatibility(mapType.getValueField(), mapType2.getValueField(), bl);
        } else if (structField.getDataType() instanceof ArrayType && structField2.getDataType() instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)structField.getDataType();
            ArrayType arrayType2 = (ArrayType)structField2.getDataType();
            SchemaUtils.validateFieldCompatibility(arrayType.getElementField(), arrayType2.getElementField(), bl);
        } else if (!structField.getDataType().equivalent(structField2.getDataType())) {
            throw new KernelException(String.format("Cannot change the type of existing field %s from %s to %s", structField.getName(), structField.getDataType(), structField2.getDataType()));
        }
    }

    private static Map<Integer, StructField> fieldsById(StructType structType) {
        List<Tuple2<List<String>, StructField>> list = SchemaUtils.filterRecursively(structType, true, false, structField -> true);
        HashMap<Integer, StructField> hashMap = new HashMap<Integer, StructField>();
        for (Tuple2<List<String>, StructField> tuple2 : list) {
            StructField structField2 = (StructField)tuple2._2;
            Preconditions.checkArgument(ColumnMapping.hasColumnId(structField2), "Field %s is missing column id", structField2.getName());
            Preconditions.checkArgument(ColumnMapping.hasPhysicalName(structField2), "Field %s is missing physical name", structField2.getName());
            int n = ColumnMapping.getColumnId(structField2);
            Preconditions.checkArgument(!hashMap.containsKey(n), "Field %s with id %d already exists", structField2.getName(), n);
            hashMap.put(n, structField2);
        }
        return hashMap;
    }

    private static String escapeDots(String string) {
        return string.contains(".") ? "`" + string + "`" : string;
    }

    private static void collectLeafColumnsInternal(StructType structType, Column column, Set<String> set, List<Column> list, int n) {
        boolean bl = n != -1;
        for (StructField structField : structType.fields()) {
            if (bl && list.size() >= n) {
                return;
            }
            Column column2 = null;
            if (column == null) {
                if (set.contains(structField.getName())) continue;
                column2 = new Column(structField.getName());
            } else {
                column2 = column.appendNestedField(structField.getName());
            }
            if (structField.getDataType() instanceof StructType) {
                SchemaUtils.collectLeafColumnsInternal((StructType)structField.getDataType(), column2, set, list, n);
                continue;
            }
            list.add(column2);
        }
    }

    protected static void validParquetColumnNames(List<String> list) {
        for (String string : list) {
            if (!string.matches(".*[ ,;{}()\n\t=].*")) continue;
            throw DeltaErrors.invalidColumnName(string, "[ ,;{}()\\n\\t=]");
        }
    }

    protected static void validateSupportedType(DataType dataType) {
        if (dataType instanceof BooleanType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType || dataType instanceof StringType || dataType instanceof BinaryType || dataType instanceof DateType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            return;
        }
        if (dataType instanceof StructType) {
            ((StructType)dataType).fields().forEach(structField -> SchemaUtils.validateSupportedType(structField.getDataType()));
        } else if (dataType instanceof ArrayType) {
            SchemaUtils.validateSupportedType(((ArrayType)dataType).getElementType());
        } else if (dataType instanceof MapType) {
            SchemaUtils.validateSupportedType(((MapType)dataType).getKeyType());
            SchemaUtils.validateSupportedType(((MapType)dataType).getValueType());
        } else {
            throw DeltaErrors.unsupportedDataType(dataType);
        }
    }
}

