/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.FileStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileNames {
    private static final Pattern DELTA_FILE_PATTERN = Pattern.compile("\\d+\\.json");
    private static final Pattern COMPACTION_FILE_PATTERN = Pattern.compile("\\d+\\.\\d+\\.compacted\\.json");
    private static final Pattern UUID_DELTA_FILE_REGEX = Pattern.compile("(\\d+)\\.([^\\.]+)\\.json");
    private static final Pattern CHECKPOINT_FILE_PATTERN = Pattern.compile("(\\d+)\\.checkpoint((\\.\\d+\\.\\d+)?\\.parquet|\\.[^.]+\\.(json|parquet))");
    private static final Pattern CLASSIC_CHECKPOINT_FILE_PATTERN = Pattern.compile("\\d+\\.checkpoint\\.parquet");
    private static final Pattern CHECK_SUM_FILE_PATTERN = Pattern.compile("(\\d+)\\.crc");
    private static final Pattern V2_CHECKPOINT_FILE_PATTERN = Pattern.compile("(\\d+)\\.checkpoint\\.[^.]+\\.(json|parquet)");
    public static final Pattern MULTI_PART_CHECKPOINT_FILE_PATTERN = Pattern.compile("(\\d+)\\.checkpoint\\.(\\d+)\\.(\\d+)\\.parquet");
    public static final String STAGED_COMMIT_DIRECTORY = "_staged_commits";
    public static final String SIDECAR_DIRECTORY = "_sidecars";

    private FileNames() {
    }

    public static DeltaLogFileType determineFileType(FileStatus fileStatus) {
        String string = fileStatus.getPath().toString();
        if (FileNames.isCommitFile(string)) {
            return DeltaLogFileType.COMMIT;
        }
        if (FileNames.isCheckpointFile(string)) {
            return DeltaLogFileType.CHECKPOINT;
        }
        if (FileNames.isLogCompactionFile(string)) {
            return DeltaLogFileType.LOG_COMPACTION;
        }
        if (FileNames.isChecksumFile(string)) {
            return DeltaLogFileType.CHECKSUM;
        }
        throw new IllegalStateException("Unexpected file type: " + string);
    }

    public static long getFileVersion(Path path) {
        if (FileNames.isCheckpointFile(path.getName())) {
            return FileNames.checkpointVersion(path);
        }
        if (FileNames.isCommitFile(path.getName())) {
            return FileNames.deltaVersion(path);
        }
        if (FileNames.isChecksumFile(path.getName())) {
            return FileNames.checksumVersion(path);
        }
        throw new IllegalArgumentException(String.format("Unexpected file type found in transaction log: %s", path));
    }

    public static long deltaVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static long deltaVersion(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        return Long.parseLong(string2.split("\\.")[0]);
    }

    public static Tuple2<Long, Long> logCompactionVersions(Path path) {
        String[] stringArray = path.getName().split("\\.");
        return new Tuple2<Long, Long>(Long.parseLong(stringArray[0]), Long.parseLong(stringArray[1]));
    }

    public static Tuple2<Long, Long> logCompactionVersions(String string) {
        return FileNames.logCompactionVersions(new Path(string));
    }

    public static long checkpointVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static long checkpointVersion(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        return Long.parseLong(string2.split("\\.")[0]);
    }

    public static Tuple2<Integer, Integer> multiPartCheckpointPartAndNumParts(Path path) {
        String string = path.getName();
        Matcher matcher = MULTI_PART_CHECKPOINT_FILE_PATTERN.matcher(string);
        Preconditions.checkArgument(matcher.matches(), String.format("Path is not a multi-part checkpoint file: %s", string));
        int n = Integer.parseInt(matcher.group(2));
        int n2 = Integer.parseInt(matcher.group(3));
        return new Tuple2<Integer, Integer>(n, n2);
    }

    public static Tuple2<Integer, Integer> multiPartCheckpointPartAndNumParts(String string) {
        return FileNames.multiPartCheckpointPartAndNumParts(new Path(string));
    }

    public static String deltaFile(Path path, long l) {
        return String.format("%s/%020d.json", path, l);
    }

    public static String stagedCommitFile(Path path, long l) {
        Path path2 = new Path(path, STAGED_COMMIT_DIRECTORY);
        return String.format("%s/%020d.%s.json", path2, l, UUID.randomUUID());
    }

    public static String sidecarFile(Path path, String string) {
        return String.format("%s/%s/%s", path.toString(), SIDECAR_DIRECTORY, string);
    }

    public static Path checksumFile(Path path, long l) {
        return new Path(path, String.format("%020d.crc", l));
    }

    public static long checksumVersion(Path path) {
        return Long.parseLong(path.getName().split("\\.")[0]);
    }

    public static long checksumVersion(String string) {
        return FileNames.checksumVersion(new Path(string));
    }

    public static String listingPrefix(Path path, long l) {
        return String.format("%s/%020d.", path, l);
    }

    public static Path checkpointFileSingular(Path path, long l) {
        return new Path(path, String.format("%020d.checkpoint.parquet", l));
    }

    public static Path topLevelV2CheckpointFile(Path path, long l, String string, String string2) {
        assert (string2.equals("json") || string2.equals("parquet"));
        return new Path(path, String.format("%020d.checkpoint.%s.%s", l, string, string2));
    }

    public static Path v2CheckpointSidecarFile(Path path, String string) {
        return new Path(String.format("%s/%s/%s.parquet", path.toString(), SIDECAR_DIRECTORY, string));
    }

    public static Path multiPartCheckpointFile(Path path, long l, int n, int n2) {
        return new Path(path, String.format("%020d.checkpoint.%010d.%010d.parquet", l, n, n2));
    }

    public static List<Path> checkpointFileWithParts(Path path, long l, int n) {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (int i = 1; i < n + 1; ++i) {
            arrayList.add(FileNames.multiPartCheckpointFile(path, l, i, n));
        }
        return arrayList;
    }

    public static Path logCompactionPath(Path path, long l, long l2) {
        String string = String.format("%020d.%020d.compacted.json", l, l2);
        return new Path(path, string);
    }

    public static boolean isCheckpointFile(String string) {
        return CHECKPOINT_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static boolean isClassicCheckpointFile(String string) {
        return CLASSIC_CHECKPOINT_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static boolean isMultiPartCheckpointFile(String string) {
        return MULTI_PART_CHECKPOINT_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static boolean isV2CheckpointFile(String string) {
        return V2_CHECKPOINT_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static boolean isCommitFile(String string) {
        String string2 = new Path(string).getName();
        return DELTA_FILE_PATTERN.matcher(string2).matches() || UUID_DELTA_FILE_REGEX.matcher(string2).matches();
    }

    public static boolean isPublishedDeltaFile(String string) {
        String string2 = new Path(string).getName();
        return DELTA_FILE_PATTERN.matcher(string2).matches();
    }

    public static boolean isStagedDeltaFile(String string) {
        Path path = new Path(string);
        if (!path.getParent().getName().equals(STAGED_COMMIT_DIRECTORY)) {
            return false;
        }
        return UUID_DELTA_FILE_REGEX.matcher(path.getName()).matches();
    }

    public static boolean isLogCompactionFile(String string) {
        String string2 = new Path(string).getName();
        return COMPACTION_FILE_PATTERN.matcher(string2).matches();
    }

    public static boolean isChecksumFile(String string) {
        return CHECK_SUM_FILE_PATTERN.matcher(new Path(string).getName()).matches();
    }

    public static enum DeltaLogFileType {
        COMMIT,
        LOG_COMPACTION,
        CHECKPOINT,
        CHECKSUM;

    }
}

