/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.data.Row;
import io.delta.kernel.exceptions.InvalidConfigurationValueException;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.data.TransactionStateRow;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class ColumnMapping {
    public static final String COLUMN_MAPPING_MODE_KEY = "delta.columnMapping.mode";
    public static final String COLUMN_MAPPING_PHYSICAL_NAME_KEY = "delta.columnMapping.physicalName";
    public static final String COLUMN_MAPPING_ID_KEY = "delta.columnMapping.id";
    public static final String COLUMN_MAPPING_NESTED_IDS_KEY = "delta.columnMapping.nested.ids";
    public static final String PARQUET_FIELD_ID_KEY = "parquet.field.id";
    public static final String PARQUET_FIELD_NESTED_IDS_METADATA_KEY = "parquet.field.nested.ids";
    public static final String COLUMN_MAPPING_MAX_COLUMN_ID_KEY = "delta.columnMapping.maxColumnId";

    private ColumnMapping() {
    }

    public static ColumnMappingMode getColumnMappingMode(Map<String, String> map) {
        return Optional.ofNullable(map.get(COLUMN_MAPPING_MODE_KEY)).map(ColumnMappingMode::fromTableConfig).orElse(ColumnMappingMode.NONE);
    }

    public static StructType convertToPhysicalSchema(StructType structType, StructType structType2, ColumnMappingMode columnMappingMode) {
        switch (columnMappingMode) {
            case NONE: {
                return structType;
            }
            case ID: 
            case NAME: {
                boolean bl = columnMappingMode == ColumnMappingMode.ID;
                return ColumnMapping.convertToPhysicalSchema(structType, structType2, bl);
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + (Object)((Object)columnMappingMode));
    }

    public static String getPhysicalName(StructField structField) {
        if (ColumnMapping.hasPhysicalName(structField)) {
            return structField.getMetadata().getString(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
        }
        return structField.getName();
    }

    public static int getColumnId(StructField structField) {
        Preconditions.checkArgument(structField.getMetadata().contains(COLUMN_MAPPING_ID_KEY), "Field does not have column id set in it's metadata");
        return structField.getMetadata().getLong(COLUMN_MAPPING_ID_KEY).intValue();
    }

    public static void verifyColumnMappingChange(Map<String, String> map, Map<String, String> map2, boolean bl) {
        ColumnMappingMode columnMappingMode = ColumnMapping.getColumnMappingMode(map);
        ColumnMappingMode columnMappingMode2 = ColumnMapping.getColumnMappingMode(map2);
        Preconditions.checkArgument(bl || ColumnMapping.validModeChange(columnMappingMode, columnMappingMode2), "Changing column mapping mode from '%s' to '%s' is not supported", new Object[]{columnMappingMode, columnMappingMode2});
    }

    public static boolean isColumnMappingModeEnabled(ColumnMappingMode columnMappingMode) {
        return columnMappingMode == ColumnMappingMode.ID || columnMappingMode == ColumnMappingMode.NAME;
    }

    public static Optional<Metadata> updateColumnMappingMetadataIfNeeded(Metadata metadata, boolean bl) {
        ColumnMappingMode columnMappingMode = ColumnMapping.getColumnMappingMode(metadata.getConfiguration());
        switch (columnMappingMode) {
            case NONE: {
                return Optional.empty();
            }
            case ID: 
            case NAME: {
                return ColumnMapping.assignColumnIdAndPhysicalName(metadata, bl);
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + (Object)((Object)columnMappingMode));
    }

    public static Tuple2<Column, DataType> getPhysicalColumnNameAndDataType(StructType structType, Column column) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DataType dataType = structType;
        for (String string : column.getNames()) {
            if (!(dataType instanceof StructType)) {
                throw DeltaErrors.columnNotFoundInSchema(column, structType);
            }
            StructType structType2 = dataType;
            StructField structField2 = structType2.fields().stream().filter(structField -> structField.getName().equalsIgnoreCase(string)).findFirst().orElseThrow(() -> DeltaErrors.columnNotFoundInSchema(column, structType));
            arrayList.add(ColumnMapping.getPhysicalName(structField2));
            dataType = structField2.getDataType();
        }
        return new Tuple2<Column, DataType>(new Column(arrayList.toArray(new String[0])), dataType);
    }

    public static void blockIfColumnMappingEnabled(Row row) {
        ColumnMappingMode columnMappingMode = TransactionStateRow.getColumnMappingMode(row);
        if (columnMappingMode != ColumnMappingMode.NONE) {
            throw new UnsupportedOperationException("Writing into column mapping enabled table is not supported yet.");
        }
    }

    static int findMaxColumnId(StructType structType) {
        int n = 0;
        for (StructField structField : structType.fields()) {
            n = ColumnMapping.findMaxColumnId(structField, n);
        }
        return n;
    }

    static boolean hasColumnId(StructField structField) {
        return structField.getMetadata().contains(COLUMN_MAPPING_ID_KEY);
    }

    static boolean hasPhysicalName(StructField structField) {
        return structField.getMetadata().contains(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
    }

    private static int findMaxColumnId(StructField structField, int n) {
        if (ColumnMapping.hasColumnId(structField)) {
            n = Math.max(n, ColumnMapping.getColumnId(structField));
            if (ColumnMapping.hasNestedColumnIds(structField)) {
                n = Math.max(n, ColumnMapping.getMaxNestedColumnId(structField));
            }
        }
        if (structField.getDataType() instanceof StructType) {
            StructType structType = (StructType)structField.getDataType();
            for (StructField structField2 : structType.fields()) {
                n = ColumnMapping.findMaxColumnId(structField2, n);
            }
            return n;
        }
        if (structField.getDataType() instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)structField.getDataType();
            return ColumnMapping.findMaxColumnId(arrayType.getElementField(), n);
        }
        if (structField.getDataType() instanceof MapType) {
            MapType mapType = (MapType)structField.getDataType();
            return Math.max(ColumnMapping.findMaxColumnId(mapType.getKeyField(), n), ColumnMapping.findMaxColumnId(mapType.getValueField(), n));
        }
        return n;
    }

    private static StructType convertToPhysicalSchema(StructType structType, StructType structType2, boolean bl) {
        StructType structType3 = new StructType();
        for (StructField structField : structType.fields()) {
            StructField structField2 = structType2.get(structField.getName());
            DataType dataType = ColumnMapping.convertToPhysicalType(structField.getDataType(), structField2.getDataType(), bl);
            String string = structField2.getMetadata().getString(COLUMN_MAPPING_PHYSICAL_NAME_KEY);
            if (bl) {
                Long l = structField2.getMetadata().getLong(COLUMN_MAPPING_ID_KEY);
                FieldMetadata.Builder builder = FieldMetadata.builder().putLong(PARQUET_FIELD_ID_KEY, l);
                if (ColumnMapping.hasNestedColumnIds(structField2)) {
                    builder.putFieldMetadata(PARQUET_FIELD_NESTED_IDS_METADATA_KEY, ColumnMapping.getNestedColumnIds(structField2));
                }
                structType3 = structType3.add(string, dataType, structField.isNullable(), builder.build());
                continue;
            }
            structType3 = structType3.add(string, dataType, structField.isNullable());
        }
        return structType3;
    }

    private static DataType convertToPhysicalType(DataType dataType, DataType dataType2, boolean bl) {
        if (dataType instanceof StructType) {
            return ColumnMapping.convertToPhysicalSchema((StructType)dataType, (StructType)dataType2, bl);
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            return new ArrayType(ColumnMapping.convertToPhysicalType(arrayType.getElementType(), ((ArrayType)dataType2).getElementType(), bl), arrayType.containsNull());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            MapType mapType2 = (MapType)dataType2;
            return new MapType(ColumnMapping.convertToPhysicalType(mapType.getKeyType(), mapType2.getKeyType(), bl), ColumnMapping.convertToPhysicalType(mapType.getValueType(), mapType2.getValueType(), bl), mapType.isValueContainsNull());
        }
        return dataType;
    }

    private static boolean validModeChange(ColumnMappingMode columnMappingMode, ColumnMappingMode columnMappingMode2) {
        return columnMappingMode.equals((Object)columnMappingMode2) || columnMappingMode == ColumnMappingMode.NONE && columnMappingMode2 == ColumnMappingMode.NAME;
    }

    private static Optional<Metadata> assignColumnIdAndPhysicalName(Metadata metadata, boolean bl) {
        boolean bl2;
        StructType structType = metadata.getSchema();
        boolean bl3 = TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.fromMetadata(metadata);
        AtomicInteger atomicInteger = new AtomicInteger(Math.max(Integer.parseInt(metadata.getConfiguration().getOrDefault(COLUMN_MAPPING_MAX_COLUMN_ID_KEY, "0")), ColumnMapping.findMaxColumnId(structType)));
        StructType structType2 = new StructType();
        for (StructField object2 : structType.fields()) {
            structType2 = structType2.add(ColumnMapping.transformAndAssignColumnIdAndPhysicalName(ColumnMapping.assignColumnIdAndPhysicalNameToField(object2, atomicInteger, bl, bl3), atomicInteger, bl, bl3));
        }
        if (Boolean.parseBoolean(metadata.getConfiguration().getOrDefault(TableConfig.ICEBERG_COMPAT_V2_ENABLED.getKey(), "false"))) {
            structType2 = ColumnMapping.rewriteFieldIdsForIceberg(structType2, atomicInteger);
        }
        boolean bl4 = bl2 = TableConfig.COLUMN_MAPPING_MAX_COLUMN_ID.fromMetadata(metadata) != (long)atomicInteger.get();
        if (structType.equals(structType2) && !bl2) {
            return Optional.empty();
        }
        String string = Integer.toString(atomicInteger.get());
        return Optional.of(metadata.withNewSchema(structType2).withMergedConfiguration(Collections.singletonMap(COLUMN_MAPPING_MAX_COLUMN_ID_KEY, string)));
    }

    private static StructField transformAndAssignColumnIdAndPhysicalName(StructField structField, AtomicInteger atomicInteger, boolean bl, boolean bl2) {
        DataType dataType = structField.getDataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructType structType2 = new StructType();
            for (StructField structField2 : structType.fields()) {
                structType2 = structType2.add(ColumnMapping.transformAndAssignColumnIdAndPhysicalName(ColumnMapping.assignColumnIdAndPhysicalNameToField(structField2, atomicInteger, bl, bl2), atomicInteger, bl, bl2));
            }
            return new StructField(structField.getName(), structType2, structField.isNullable(), structField.getMetadata());
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            StructField structField3 = ColumnMapping.transformAndAssignColumnIdAndPhysicalName(arrayType.getElementField(), atomicInteger, bl, bl2);
            return new StructField(structField.getName(), new ArrayType(structField3), structField.isNullable(), structField.getMetadata());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            StructField structField4 = ColumnMapping.transformAndAssignColumnIdAndPhysicalName(mapType.getKeyField(), atomicInteger, bl, bl2);
            StructField structField5 = ColumnMapping.transformAndAssignColumnIdAndPhysicalName(mapType.getValueField(), atomicInteger, bl, bl2);
            return new StructField(structField.getName(), new MapType(structField4, structField5), structField.isNullable(), structField.getMetadata());
        }
        return structField;
    }

    private static StructField assignColumnIdAndPhysicalNameToField(StructField structField, AtomicInteger atomicInteger, boolean bl, boolean bl2) {
        if (ColumnMapping.hasColumnId(structField) ^ ColumnMapping.hasPhysicalName(structField)) {
            throw new IllegalArgumentException(String.format("Both columnId and physicalName must be present if one is present. Found this field with incomplete column mapping metadata: %s", structField));
        }
        if (!ColumnMapping.hasColumnId(structField)) {
            structField = structField.withNewMetadata(FieldMetadata.builder().fromMetadata(structField.getMetadata()).putLong(COLUMN_MAPPING_ID_KEY, atomicInteger.incrementAndGet()).build());
        }
        if (!ColumnMapping.hasPhysicalName(structField)) {
            String string;
            if (bl2) {
                long l = ColumnMapping.getColumnId(structField);
                string = String.format("col-%s", l);
            } else {
                string = bl ? "col-" + UUID.randomUUID() : structField.getName();
            }
            structField = structField.withNewMetadata(FieldMetadata.builder().fromMetadata(structField.getMetadata()).putString(COLUMN_MAPPING_PHYSICAL_NAME_KEY, string).build());
        }
        return structField;
    }

    private static boolean hasNestedColumnIds(StructField structField) {
        return structField.getMetadata().contains(COLUMN_MAPPING_NESTED_IDS_KEY);
    }

    private static FieldMetadata getNestedColumnIds(StructField structField) {
        return structField.getMetadata().getMetadata(COLUMN_MAPPING_NESTED_IDS_KEY);
    }

    private static int getMaxNestedColumnId(StructField structField) {
        return ColumnMapping.getNestedColumnIds(structField).getEntries().values().stream().filter(Long.class::isInstance).map(Long.class::cast).max(Comparator.naturalOrder()).orElse(0L).intValue();
    }

    private static StructType rewriteFieldIdsForIceberg(StructType structType, AtomicInteger atomicInteger) {
        StructType structType2 = new StructType();
        for (StructField structField : structType.fields()) {
            FieldMetadata.Builder builder = FieldMetadata.builder().fromMetadata(structField.getMetadata());
            structType2 = structType2.add(ColumnMapping.transformSchema(atomicInteger, structField, "", builder).withNewMetadata(builder.build()));
        }
        return structType2;
    }

    private static StructField transformSchema(AtomicInteger atomicInteger, StructField structField2, String string, FieldMetadata.Builder builder) {
        DataType dataType = structField2.getDataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            List<StructField> list = structType.fields().stream().map(structField -> {
                FieldMetadata.Builder builder = FieldMetadata.builder().fromMetadata(structField.getMetadata());
                return ColumnMapping.transformSchema(atomicInteger, structField, ColumnMapping.getPhysicalName(structField), builder).withNewMetadata(builder.build());
            }).collect(Collectors.toList());
            return new StructField(structField2.getName(), new StructType(list), structField2.isNullable(), structField2.getMetadata());
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            String string2 = "".equals(string) ? ColumnMapping.getPhysicalName(structField2) : string;
            String string3 = string2 + "." + arrayType.getElementField().getName();
            ColumnMapping.maybeUpdateFieldId(builder, string3, atomicInteger);
            StructField structField3 = ColumnMapping.transformSchema(atomicInteger, arrayType.getElementField(), string3, builder);
            return new StructField(structField2.getName(), new ArrayType(structField3), structField2.isNullable(), structField2.getMetadata());
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            String string4 = "".equals(string) ? ColumnMapping.getPhysicalName(structField2) : string;
            String string5 = string4 + "." + mapType.getKeyField().getName();
            ColumnMapping.maybeUpdateFieldId(builder, string5, atomicInteger);
            StructField structField4 = ColumnMapping.transformSchema(atomicInteger, mapType.getKeyField(), string5, builder);
            String string6 = string4 + "." + mapType.getValueField().getName();
            ColumnMapping.maybeUpdateFieldId(builder, string6, atomicInteger);
            StructField structField5 = ColumnMapping.transformSchema(atomicInteger, mapType.getValueField(), string6, builder);
            return new StructField(structField2.getName(), new MapType(structField4, structField5), structField2.isNullable(), structField2.getMetadata());
        }
        return structField2;
    }

    private static void maybeUpdateFieldId(FieldMetadata.Builder builder, String string, AtomicInteger atomicInteger) {
        FieldMetadata fieldMetadata = builder.getMetadata(COLUMN_MAPPING_NESTED_IDS_KEY);
        if (builder.getMetadata(COLUMN_MAPPING_NESTED_IDS_KEY) == null) {
            builder.putFieldMetadata(COLUMN_MAPPING_NESTED_IDS_KEY, FieldMetadata.empty());
            fieldMetadata = builder.getMetadata(COLUMN_MAPPING_NESTED_IDS_KEY);
        }
        if (!fieldMetadata.contains(string)) {
            FieldMetadata fieldMetadata2 = FieldMetadata.builder().fromMetadata(fieldMetadata).putLong(string, atomicInteger.incrementAndGet()).build();
            builder.putFieldMetadata(COLUMN_MAPPING_NESTED_IDS_KEY, fieldMetadata2);
        }
    }

    public static enum ColumnMappingMode {
        NONE("none"),
        ID("id"),
        NAME("name");

        public final String value;

        private ColumnMappingMode(String string2) {
            this.value = string2;
        }

        public static ColumnMappingMode fromTableConfig(String string) {
            for (ColumnMappingMode columnMappingMode : ColumnMappingMode.values()) {
                if (!columnMappingMode.value.equalsIgnoreCase(string)) continue;
                return columnMappingMode;
            }
            throw new InvalidConfigurationValueException(ColumnMapping.COLUMN_MAPPING_MODE_KEY, string, String.format("Needs to be one of: %s.", Arrays.toString((Object[])ColumnMappingMode.values())));
        }

        public String toString() {
            return this.value;
        }
    }
}

