/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.tablefeatures;

import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.tablefeatures.FeatureAutoEnabledByMetadata;
import io.delta.kernel.internal.util.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public abstract class TableFeature {
    private final String featureName;
    private final int minReaderVersion;
    private final int minWriterVersion;

    public TableFeature(String string, int n2, int n3) {
        this.featureName = Objects.requireNonNull(string, "name is null");
        Preconditions.checkArgument(!string.isEmpty(), "name is empty");
        Preconditions.checkArgument(string.chars().allMatch(n -> Character.isLetterOrDigit(n) || n == 45 || n == 95), "name contains invalid characters: " + string);
        Preconditions.checkArgument(n2 >= 0, "minReaderVersion is negative");
        Preconditions.checkArgument(n3 >= 1, "minWriterVersion is less than 1");
        this.minReaderVersion = n2;
        this.minWriterVersion = n3;
        this.validate();
    }

    public String featureName() {
        return this.featureName;
    }

    public boolean isReaderWriterFeature() {
        return this instanceof ReaderWriterFeatureType;
    }

    public int minReaderVersion() {
        return this.minReaderVersion;
    }

    public int minWriterVersion() {
        return this.minWriterVersion;
    }

    public boolean isLegacyFeature() {
        return this instanceof LegacyFeatureType;
    }

    public Set<TableFeature> requiredFeatures() {
        return Collections.emptySet();
    }

    public boolean hasKernelReadSupport() {
        Preconditions.checkArgument(this.isReaderWriterFeature(), "Should be called only for reader-writer features");
        return true;
    }

    public boolean hasKernelWriteSupport(Metadata metadata) {
        return true;
    }

    private void validate() {
        if (!this.isReaderWriterFeature()) {
            Preconditions.checkArgument(this.minReaderVersion() == 0, "Writer-only feature must have minReaderVersion=0");
        }
    }

    public static interface ReaderWriterFeatureType {
    }

    public static interface LegacyFeatureType
    extends FeatureAutoEnabledByMetadata {
    }

    public static abstract class ReaderWriterFeature
    extends TableFeature
    implements ReaderWriterFeatureType {
        public ReaderWriterFeature(String string, int n, int n2) {
            super(string, n, n2);
        }
    }

    public static abstract class WriterFeature
    extends TableFeature {
        public WriterFeature(String string, int n) {
            super(string, 0, n);
        }

        @Override
        public boolean hasKernelReadSupport() {
            return true;
        }
    }

    public static abstract class LegacyReaderWriterFeature
    extends TableFeature
    implements LegacyFeatureType,
    ReaderWriterFeatureType {
        public LegacyReaderWriterFeature(String string, int n, int n2) {
            super(string, n, n2);
        }
    }

    public static abstract class LegacyWriterFeature
    extends TableFeature
    implements LegacyFeatureType {
        public LegacyWriterFeature(String string, int n) {
            super(string, 0, n);
        }

        @Override
        public boolean hasKernelReadSupport() {
            return true;
        }
    }
}

