/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.Snapshot;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.InvalidTableException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaHistoryManager;
import io.delta.kernel.internal.DeltaLogActionUtils;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.annotation.VisibleForTesting;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.Checkpointer;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.metrics.SnapshotQueryContext;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.FileStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotManager {
    private final AtomicReference<SnapshotHint> latestSnapshotHint = new AtomicReference();
    private final Path tablePath;
    private final Path logPath;
    private static final Logger logger = LoggerFactory.getLogger(SnapshotManager.class);

    public SnapshotManager(Path path) {
        this.tablePath = path;
        this.logPath = new Path(path, "_delta_log");
    }

    public Snapshot buildLatestSnapshot(Engine engine, SnapshotQueryContext snapshotQueryContext) throws TableNotFoundException {
        LogSegment logSegment = this.getLogSegmentForVersion(engine, Optional.empty());
        snapshotQueryContext.setVersion(logSegment.getVersion());
        return this.createSnapshot(logSegment, engine, snapshotQueryContext);
    }

    public SnapshotImpl getSnapshotAt(Engine engine, long l, SnapshotQueryContext snapshotQueryContext) throws TableNotFoundException {
        LogSegment logSegment = this.getLogSegmentForVersion(engine, Optional.of(l));
        return this.createSnapshot(logSegment, engine, snapshotQueryContext);
    }

    public Snapshot getSnapshotForTimestamp(Engine engine, long l, SnapshotQueryContext snapshotQueryContext) throws TableNotFoundException {
        long l2 = snapshotQueryContext.getSnapshotMetrics().timestampToVersionResolutionTimer.time(() -> DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.logPath, l, true, false, false).getVersion());
        logger.info("{}: Took {} ms to fetch version at timestamp {}", new Object[]{this.tablePath, snapshotQueryContext.getSnapshotMetrics().timestampToVersionResolutionTimer.totalDurationMs(), l});
        snapshotQueryContext.setVersion(l2);
        return this.getSnapshotAt(engine, l2, snapshotQueryContext);
    }

    @VisibleForTesting
    public static void verifyDeltaVersionsContiguous(List<Long> list, Path path) {
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i) == list.get(i - 1) + 1L) continue;
            throw new InvalidTableException(path.toString(), String.format("Missing delta files: versions are not contiguous: (%s)", list));
        }
    }

    private void registerHint(SnapshotHint snapshotHint) {
        this.latestSnapshotHint.updateAndGet(snapshotHint2 -> {
            if (snapshotHint2 == null) {
                return snapshotHint;
            }
            if (snapshotHint.getVersion() > snapshotHint2.getVersion()) {
                return snapshotHint;
            }
            return snapshotHint2;
        });
    }

    private SnapshotImpl createSnapshot(LogSegment logSegment, Engine engine, SnapshotQueryContext snapshotQueryContext) {
        String string = logSegment.getCheckpointVersionOpt().map(l -> String.format("starting from checkpoint version %s.", l)).orElse(".");
        logger.info("{}: Loading version {} {}", new Object[]{this.tablePath, logSegment.getVersion(), string});
        long l2 = System.currentTimeMillis();
        LogReplay logReplay = new LogReplay(this.logPath, this.tablePath, engine, logSegment, Optional.ofNullable(this.latestSnapshotHint.get()), snapshotQueryContext.getSnapshotMetrics());
        LogReplayUtils.assertLogFilesBelongToTable(this.logPath, logSegment.allLogFilesUnsorted());
        SnapshotImpl snapshotImpl = new SnapshotImpl(this.tablePath, logSegment, logReplay, logReplay.getProtocol(), logReplay.getMetadata(), snapshotQueryContext);
        engine.getMetricsReporters().forEach(metricsReporter -> metricsReporter.report(snapshotImpl.getSnapshotReport()));
        logger.info("{}: Took {}ms to construct the snapshot (loading protocol and metadata) for {} {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, logSegment.getVersion(), string});
        SnapshotHint snapshotHint = new SnapshotHint(snapshotImpl.getVersion(), snapshotImpl.getProtocol(), snapshotImpl.getMetadata());
        this.registerHint(snapshotHint);
        return snapshotImpl;
    }

    @VisibleForTesting
    public LogSegment getLogSegmentForVersion(Engine engine, Optional<Long> optional) {
        FileStatus fileStatus2;
        long l3;
        String string = optional.map(String::valueOf).orElse("latest");
        logger.info("Loading log segment for version {}", (Object)string);
        Optional<Long> optional2 = this.getStartCheckpointVersion(engine, optional);
        long l4 = optional2.map(l -> {
            logger.info("Found a complete checkpoint at version {}.", l);
            return l;
        }).orElseGet(() -> {
            logger.warn("Cannot find a complete checkpoint. Listing from version 0.");
            return 0L;
        });
        HashSet<FileNames.DeltaLogFileType> hashSet = new HashSet<FileNames.DeltaLogFileType>(Arrays.asList(FileNames.DeltaLogFileType.COMMIT, FileNames.DeltaLogFileType.CHECKPOINT, FileNames.DeltaLogFileType.CHECKSUM));
        hashSet.add(FileNames.DeltaLogFileType.LOG_COMPACTION);
        long l5 = System.currentTimeMillis();
        List<FileStatus> list = DeltaLogActionUtils.listDeltaLogFilesAsIter(engine, hashSet, this.tablePath, l4, optional, true).toInMemoryList();
        logger.info("{}: Took {}ms to list the files after starting checkpoint", (Object)this.tablePath, (Object)(System.currentTimeMillis() - l5));
        if (list.isEmpty()) {
            if (optional2.isPresent()) {
                throw DeltaErrors.missingCheckpoint(this.tablePath.toString(), optional2.get());
            }
            throw new TableNotFoundException(this.tablePath.toString(), String.format("No delta files found in the directory: %s", this.logPath));
        }
        this.logDebugFileStatuses("listedFileStatuses", list);
        Map map = list.stream().collect(Collectors.groupingBy(FileNames::determineFileType, LinkedHashMap::new, Collectors.toList()));
        List<FileStatus> list2 = map.getOrDefault((Object)FileNames.DeltaLogFileType.COMMIT, Collections.emptyList());
        List<FileStatus> list3 = map.getOrDefault((Object)FileNames.DeltaLogFileType.CHECKPOINT, Collections.emptyList());
        List<FileStatus> list4 = map.getOrDefault((Object)FileNames.DeltaLogFileType.LOG_COMPACTION, Collections.emptyList());
        List<FileStatus> list5 = map.getOrDefault((Object)FileNames.DeltaLogFileType.CHECKSUM, Collections.emptyList());
        this.logDebugFileStatuses("listedCheckpointFileStatuses", list3);
        this.logDebugFileStatuses("listedCompactionFileStatuses", list4);
        this.logDebugFileStatuses("listedDeltaFileStatuses", list2);
        this.logDebugFileStatuses("listedCheckSumFileStatuses", list5);
        List<CheckpointInstance> list6 = list3.stream().map(fileStatus -> new CheckpointInstance(fileStatus.getPath())).collect(Collectors.toList());
        CheckpointInstance checkpointInstance2 = optional.map(CheckpointInstance::new).orElse(CheckpointInstance.MAX_VALUE);
        Optional<CheckpointInstance> optional3 = Checkpointer.getLatestCompleteCheckpointFromList(list6, checkpointInstance2);
        if (!optional3.isPresent() && optional2.isPresent()) {
            throw DeltaErrors.missingCheckpoint(this.tablePath.toString(), optional2.get());
        }
        long l6 = optional3.map(checkpointInstance -> checkpointInstance.version).orElse(-1L);
        logger.info("Latest complete checkpoint version: {}", (Object)l6);
        List<FileStatus> list7 = list2.stream().filter(fileStatus -> {
            long l2 = FileNames.deltaVersion(new Path(fileStatus.getPath()));
            return l6 + 1L <= l2 && l2 <= optional.orElse(Long.MAX_VALUE);
        }).collect(Collectors.toList());
        this.logDebugFileStatuses("deltasAfterCheckpoint", list7);
        List<FileStatus> list8 = list4.stream().filter(fileStatus -> {
            Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(new Path(fileStatus.getPath()));
            return l6 + 1L <= (Long)tuple2._1 && (Long)tuple2._2 <= optional.orElse(Long.MAX_VALUE);
        }).collect(Collectors.toList());
        this.logDebugFileStatuses("compactionsAfterCheckpoint", list8);
        List<Long> list9 = list7.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toList());
        long l7 = list9.isEmpty() ? l6 : (Long)ListUtils.getLast(list9);
        logger.info("New version to load: {}", (Object)l7);
        if (!optional3.isPresent() && list7.isEmpty()) {
            throw new InvalidTableException(this.tablePath.toString(), "No complete checkpoint found and no delta files found");
        }
        if (optional3.isPresent() && list2.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).noneMatch(l2 -> l2 == l6)) {
            throw new InvalidTableException(this.tablePath.toString(), String.format("Missing delta file for version %s", l6));
        }
        optional.ifPresent(l2 -> {
            if (l7 < l2) {
                throw DeltaErrors.versionToLoadAfterLatestCommit(this.tablePath.toString(), l2, l7);
            }
            if (l7 > l2) {
                throw new IllegalStateException(String.format("%s: Expected to load version %s but actually loaded version %s", this.tablePath, l2, l7));
            }
        });
        if (!list7.isEmpty()) {
            SnapshotManager.verifyDeltaVersionsContiguous(list9, this.tablePath);
            if (!list9.get(0).equals(l6 + 1L)) {
                throw new InvalidTableException(this.tablePath.toString(), String.format("Cannot compute snapshot. Missing delta file version %d.", l6 + 1L));
            }
            logger.info("Verified delta files are contiguous from version {} to {}", (Object)(l6 + 1L), (Object)l7);
        }
        List<FileStatus> list10 = optional3.map(checkpointInstance -> {
            HashSet<Path> hashSet = new HashSet<Path>(checkpointInstance.getCorrespondingFiles(this.logPath));
            List<FileStatus> list2 = list3.stream().filter(fileStatus -> hashSet.contains(new Path(fileStatus.getPath()))).collect(Collectors.toList());
            this.logDebugFileStatuses("newCheckpointFileStatuses", list2);
            if (list2.size() != hashSet.size()) {
                String string = String.format("Seems like the checkpoint is corrupted. Failed in getting the file information for:\n%s\namong\n%s", hashSet.stream().map(Path::toString).collect(Collectors.joining("\n - ")), list3.stream().map(FileStatus::getPath).collect(Collectors.joining("\n - ")));
                throw new IllegalStateException(string);
            }
            return list2;
        }).orElse(Collections.emptyList());
        Optional<FileStatus> optional4 = Optional.empty();
        if (!list5.isEmpty() && (l3 = FileNames.checksumVersion(new Path((fileStatus2 = ListUtils.getLast(list5)).getPath()))) >= l6) {
            optional4 = Optional.of(fileStatus2);
        }
        logger.info("Successfully constructed LogSegment at version {}", (Object)l7);
        long l8 = ListUtils.getLast(list2).getModificationTime();
        return new LogSegment(this.logPath, l7, list7, list8, list10, optional4, l8);
    }

    private Optional<Long> getStartCheckpointVersion(Engine engine, Optional<Long> optional) {
        return optional.map(l -> {
            logger.info("Finding last complete checkpoint at or before version {}", l);
            long l2 = System.currentTimeMillis();
            return Checkpointer.findLastCompleteCheckpointBefore(engine, this.logPath, l + 1L).map(checkpointInstance -> checkpointInstance.version).map(l3 -> {
                Preconditions.checkArgument(l3 <= l, "Last complete checkpoint version %s was not <= targetVersion %s", l3, l);
                logger.info("{}: Took {}ms to find last complete checkpoint <= targetVersion {}", new Object[]{this.tablePath, System.currentTimeMillis() - l2, l});
                return l3;
            });
        }).orElseGet(() -> new Checkpointer(this.logPath).readLastCheckpointFile(engine).map(checkpointMetaData -> checkpointMetaData.version));
    }

    private void logDebugFileStatuses(String string, List<FileStatus> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {}", (Object)string, (Object)Arrays.toString(list.stream().map(fileStatus -> new Path(fileStatus.getPath()).getName()).toArray()));
        }
    }
}

