/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.snapshot;

import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.Checkpointer;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataCleanup {
    private static final Logger logger = LoggerFactory.getLogger(MetadataCleanup.class);

    private MetadataCleanup() {
    }

    public static long cleanupExpiredLogs(Engine engine, Clock clock, Path path, long l) throws IOException {
        Preconditions.checkArgument(l >= 0L, "Retention period must be non-negative");
        ArrayList<String> arrayList = new ArrayList<String>();
        long l2 = -1L;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        long l3 = clock.getTimeMillis() - l;
        logger.info("{}: Starting the deletion of log files older than {}", (Object)path, (Object)l3);
        long l4 = 0L;
        try (CloseableIterator<FileStatus> closeableIterator = MetadataCleanup.listDeltaLogs(engine, path);){
            while (closeableIterator.hasNext()) {
                FileStatus fileStatus;
                Optional<CheckpointInstance> optional = Checkpointer.getLatestCompleteCheckpointFromList(arrayList2.stream().map(CheckpointInstance::new).collect(Collectors.toList()), CheckpointInstance.MAX_VALUE);
                if (optional.isPresent()) {
                    if (!arrayList.isEmpty()) {
                        logger.info("{}: Deleting log files (start = {}, end = {}) because a checkpoint at version {} indicates that these log files are no longer needed.", new Object[]{path, ListUtils.getFirst(arrayList), ListUtils.getLast(arrayList), l2});
                        l4 += (long)MetadataCleanup.deleteLogFiles(engine, arrayList);
                        arrayList.clear();
                    }
                    arrayList.addAll(arrayList2);
                    arrayList2.clear();
                    l2 = -1L;
                }
                if ((fileStatus = closeableIterator.next()).getModificationTime() > l3) {
                    if (!arrayList.isEmpty()) {
                        logger.info("{}: Skipping deletion of expired log files {}, because there is no checkpoint file that indicates that the log files are no longer needed. ", (Object)path, (Object)arrayList.size());
                    }
                    break;
                }
                if (FileNames.isCommitFile(fileStatus.getPath())) {
                    arrayList.add(fileStatus.getPath());
                    continue;
                }
                if (!FileNames.isCheckpointFile(fileStatus.getPath())) continue;
                long l5 = FileNames.checkpointVersion(fileStatus.getPath());
                Preconditions.checkArgument(l2 == -1L || l5 >= l2);
                if (l2 != -1L && l5 > l2) {
                    logger.info("{}: Incomplete checkpoint files found at version {}, ignoring the checkpoint files and adding them to potential log file delete list", (Object)path, (Object)l2);
                    arrayList.addAll(arrayList2);
                    arrayList2.clear();
                }
                arrayList2.add(fileStatus.getPath());
                l2 = l5;
            }
        }
        logger.info("{}: Deleted {} log files older than {}", new Object[]{path, l4, l3});
        return l4;
    }

    private static CloseableIterator<FileStatus> listDeltaLogs(Engine engine, Path path) throws IOException {
        Path path2 = new Path(path, "_delta_log");
        return engine.getFileSystemClient().listFrom(FileNames.listingPrefix(path2, 0L));
    }

    private static int deleteLogFiles(Engine engine, List<String> list) throws IOException {
        int n = 0;
        for (String string : list) {
            if (!DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().delete(string), "Failed to delete the log file as part of the metadata cleanup %s", string).booleanValue()) continue;
            ++n;
        }
        return n;
    }
}

