/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.skipping;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.expressions.Expression;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class StatsSchemaHelper {
    public static final String NUM_RECORDS = "numRecords";
    public static final String MIN = "minValues";
    public static final String MAX = "maxValues";
    public static final String NULL_COUNT = "nullCount";
    private final StructType dataSchema;
    private final Map<Column, Column> logicalToPhysicalColumn;
    private final Map<Column, DataType> logicalToDataType;
    private static final Set<String> SKIPPING_ELIGIBLE_TYPE_NAMES = new HashSet<String>(){
        {
            this.add("byte");
            this.add("short");
            this.add("integer");
            this.add("long");
            this.add("float");
            this.add("double");
            this.add("date");
            this.add("timestamp");
            this.add("timestamp_ntz");
            this.add("string");
        }
    };

    public static boolean isSkippingEligibleLiteral(Literal literal) {
        return StatsSchemaHelper.isSkippingEligibleDataType(literal.getDataType());
    }

    public static boolean isSkippingEligibleDataType(DataType dataType) {
        return SKIPPING_ELIGIBLE_TYPE_NAMES.contains(dataType.toString()) || dataType instanceof DecimalType;
    }

    public static StructType getStatsSchema(StructType structType) {
        StructType structType2;
        StructType structType3 = new StructType().add(NUM_RECORDS, (DataType)LongType.LONG, true);
        StructType structType4 = StatsSchemaHelper.getMinMaxStatsSchema(structType);
        if (structType4.length() > 0) {
            structType3 = structType3.add(MIN, (DataType)StatsSchemaHelper.getMinMaxStatsSchema(structType), true).add(MAX, (DataType)StatsSchemaHelper.getMinMaxStatsSchema(structType), true);
        }
        if ((structType2 = StatsSchemaHelper.getNullCountSchema(structType)).length() > 0) {
            structType3 = structType3.add(NULL_COUNT, (DataType)StatsSchemaHelper.getNullCountSchema(structType), true);
        }
        return structType3;
    }

    public StatsSchemaHelper(StructType structType) {
        this.dataSchema = structType;
        Map<Column, Tuple2<Column, DataType>> map = this.getLogicalToPhysicalColumnAndDataType(structType);
        this.logicalToPhysicalColumn = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Column)((Tuple2)entry.getValue())._1));
        this.logicalToDataType = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (DataType)((Tuple2)entry.getValue())._2));
    }

    public Tuple2<Column, Optional<Expression>> getMinColumn(Column column) {
        Preconditions.checkArgument(this.isSkippingEligibleMinMaxColumn(column), "%s is not a valid min column for data schema %s", column, this.dataSchema);
        return new Tuple2<Column, Optional<Expression>>(this.getStatsColumn(column, MIN), Optional.empty());
    }

    public Tuple2<Column, Optional<Expression>> getMaxColumn(Column column) {
        Preconditions.checkArgument(this.isSkippingEligibleMinMaxColumn(column), "%s is not a valid min column for data schema %s", column, this.dataSchema);
        DataType dataType = this.logicalToDataType.get(column);
        Column column2 = this.getStatsColumn(column, MAX);
        if (dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            return new Tuple2<Column, Optional<Expression>>(column2, Optional.of(new ScalarExpression("TIMEADD", Arrays.asList(column2, Literal.ofLong(1L)))));
        }
        return new Tuple2<Column, Optional<Expression>>(column2, Optional.empty());
    }

    public Column getNullCountColumn(Column column) {
        Preconditions.checkArgument(this.isSkippingEligibleNullCountColumn(column), "%s is not a valid null_count column for data schema %s", column, this.dataSchema);
        return this.getStatsColumn(column, NULL_COUNT);
    }

    public Column getNumRecordsColumn() {
        return new Column(NUM_RECORDS);
    }

    public boolean isSkippingEligibleMinMaxColumn(Column column) {
        return this.logicalToDataType.containsKey(column) && StatsSchemaHelper.isSkippingEligibleDataType(this.logicalToDataType.get(column));
    }

    public boolean isSkippingEligibleNullCountColumn(Column column) {
        return this.logicalToPhysicalColumn.containsKey(column);
    }

    private static StructType getMinMaxStatsSchema(StructType structType) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        for (StructField structField : structType.fields()) {
            if (StatsSchemaHelper.isSkippingEligibleDataType(structField.getDataType())) {
                arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), structField.getDataType(), true));
                continue;
            }
            if (!(structField.getDataType() instanceof StructType)) continue;
            arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), StatsSchemaHelper.getMinMaxStatsSchema((StructType)structField.getDataType()), true));
        }
        return new StructType(arrayList);
    }

    private static StructType getNullCountSchema(StructType structType) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>();
        for (StructField structField : structType.fields()) {
            if (structField.getDataType() instanceof StructType) {
                arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), StatsSchemaHelper.getNullCountSchema((StructType)structField.getDataType()), true));
                continue;
            }
            arrayList.add(new StructField(ColumnMapping.getPhysicalName(structField), LongType.LONG, true));
        }
        return new StructType(arrayList);
    }

    private Column getStatsColumn(Column column, String string) {
        Preconditions.checkArgument(this.logicalToPhysicalColumn.containsKey(column), "%s is not a valid leaf column for data schema: %s", column, this.dataSchema);
        return StatsSchemaHelper.getChildColumn(this.logicalToPhysicalColumn.get(column), string);
    }

    private Map<Column, Tuple2<Column, DataType>> getLogicalToPhysicalColumnAndDataType(StructType structType) {
        HashMap<Column, Tuple2<Column, DataType>> hashMap = new HashMap<Column, Tuple2<Column, DataType>>();
        for (StructField structField : structType.fields()) {
            if (structField.getDataType() instanceof StructType) {
                Map<Column, Tuple2<Column, DataType>> map = this.getLogicalToPhysicalColumnAndDataType((StructType)structField.getDataType());
                for (Column column : map.keySet()) {
                    Tuple2<Column, DataType> tuple2 = map.get(column);
                    Column column2 = (Column)tuple2._1;
                    DataType dataType = (DataType)tuple2._2;
                    hashMap.put(StatsSchemaHelper.getChildColumn(column, structField.getName()), new Tuple2<Column, DataType>(StatsSchemaHelper.getChildColumn(column2, ColumnMapping.getPhysicalName(structField)), dataType));
                }
                continue;
            }
            hashMap.put(new Column(structField.getName()), new Tuple2<Column, DataType>(new Column(ColumnMapping.getPhysicalName(structField)), structField.getDataType()));
        }
        return hashMap;
    }

    private static Column getChildColumn(Column column, String string) {
        return new Column(StatsSchemaHelper.prependArray(column.getNames(), string));
    }

    private static String[] prependArray(String[] stringArray, String string) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }
}

