/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.internal.metrics.Counter;
import io.delta.kernel.internal.metrics.Timer;
import io.delta.kernel.internal.stats.FileSizeHistogram;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.metrics.FileSizeHistogramResult;
import io.delta.kernel.metrics.TransactionMetricsResult;
import java.util.Optional;

public class TransactionMetrics {
    public final Timer totalCommitTimer = new Timer();
    public final Counter commitAttemptsCounter = new Counter();
    private final Counter addFilesCounter = new Counter();
    private final Counter removeFilesCounter = new Counter();
    public final Counter totalActionsCounter = new Counter();
    private final Counter addFilesSizeInBytesCounter = new Counter();
    private final Counter removeFilesSizeInBytesCounter = new Counter();
    private Optional<FileSizeHistogram> tableFileSizeHistogram;

    public static TransactionMetrics forNewTable() {
        return new TransactionMetrics(Optional.of(FileSizeHistogram.createDefaultHistogram()));
    }

    public static TransactionMetrics withExistingTableFileSizeHistogram(Optional<FileSizeHistogram> optional) {
        return new TransactionMetrics(optional);
    }

    private TransactionMetrics(Optional<FileSizeHistogram> optional) {
        this.tableFileSizeHistogram = optional;
    }

    public void updateForAddFile(long l) {
        Preconditions.checkArgument(l >= 0L, "File size must be non-negative, got %s", l);
        this.addFilesCounter.increment();
        this.addFilesSizeInBytesCounter.increment(l);
        this.tableFileSizeHistogram.ifPresent(fileSizeHistogram -> fileSizeHistogram.insert(l));
    }

    public void updateForRemoveFile(long l) {
        Preconditions.checkArgument(l >= 0L, "File size must be non-negative, got %s", l);
        this.removeFilesCounter.increment();
        this.removeFilesSizeInBytesCounter.increment(l);
        this.tableFileSizeHistogram.ifPresent(fileSizeHistogram -> fileSizeHistogram.remove(l));
    }

    public void resetActionMetricsForRetry() {
        this.addFilesCounter.reset();
        this.addFilesSizeInBytesCounter.reset();
        this.removeFilesCounter.reset();
        this.totalActionsCounter.reset();
        this.removeFilesSizeInBytesCounter.reset();
        this.tableFileSizeHistogram = Optional.empty();
    }

    public TransactionMetricsResult captureTransactionMetricsResult() {
        return new TransactionMetricsResult(){
            final long totalCommitDurationNs;
            final long numCommitAttempts;
            final long numAddFiles;
            final long totalAddFilesSizeInBytes;
            final long numRemoveFiles;
            final long numTotalActions;
            final long totalRemoveFileSizeInBytes;
            final Optional<FileSizeHistogramResult> tableFileSizeHistogramResult;
            {
                this.totalCommitDurationNs = TransactionMetrics.this.totalCommitTimer.totalDurationNs();
                this.numCommitAttempts = TransactionMetrics.this.commitAttemptsCounter.value();
                this.numAddFiles = TransactionMetrics.this.addFilesCounter.value();
                this.totalAddFilesSizeInBytes = TransactionMetrics.this.addFilesSizeInBytesCounter.value();
                this.numRemoveFiles = TransactionMetrics.this.removeFilesCounter.value();
                this.numTotalActions = TransactionMetrics.this.totalActionsCounter.value();
                this.totalRemoveFileSizeInBytes = TransactionMetrics.this.removeFilesSizeInBytesCounter.value();
                this.tableFileSizeHistogramResult = TransactionMetrics.this.tableFileSizeHistogram.map(FileSizeHistogram::captureFileSizeHistogramResult);
            }

            @Override
            public long getTotalCommitDurationNs() {
                return this.totalCommitDurationNs;
            }

            @Override
            public long getNumCommitAttempts() {
                return this.numCommitAttempts;
            }

            @Override
            public long getNumAddFiles() {
                return this.numAddFiles;
            }

            @Override
            public long getNumRemoveFiles() {
                return this.numRemoveFiles;
            }

            @Override
            public long getNumTotalActions() {
                return this.numTotalActions;
            }

            @Override
            public long getTotalAddFilesSizeInBytes() {
                return this.totalAddFilesSizeInBytes;
            }

            @Override
            public long getTotalRemoveFilesSizeInBytes() {
                return this.totalRemoveFileSizeInBytes;
            }

            @Override
            public Optional<FileSizeHistogramResult> getTableFileSizeHistogram() {
                return this.tableFileSizeHistogramResult;
            }
        };
    }

    public String toString() {
        return String.format("TransactionMetrics(totalCommitTimer=%s, commitAttemptsCounter=%s, addFilesCounter=%s, removeFilesCounter=%s, totalActionsCounter=%s, totalAddFilesSizeInBytes=%s,totalRemoveFilesSizeInBytes=%s, tableFileSizeHistogram=%s)", this.totalCommitTimer, this.commitAttemptsCounter, this.addFilesCounter, this.removeFilesCounter, this.totalActionsCounter, this.addFilesSizeInBytesCounter, this.removeFilesSizeInBytesCounter, this.tableFileSizeHistogram);
    }
}

