/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.internal.util.Preconditions;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class Timer {
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();

    public long count() {
        return this.count.longValue();
    }

    public long totalDurationNs() {
        return this.totalTime.longValue();
    }

    public long totalDurationMs() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalDurationNs());
    }

    public Optional<Long> totalDurationIfRecorded() {
        return this.count() > 0L ? Optional.of(this.totalDurationNs()) : Optional.empty();
    }

    public Timed start() {
        return new DefaultTimed(this);
    }

    public void record(long l) {
        Preconditions.checkArgument(l >= 0L, "Cannot record %s: must be >= 0", l);
        this.totalTime.add(l);
        this.count.increment();
    }

    public <T> T time(Supplier<T> supplier) {
        try (Timed timed = this.start();){
            T t = supplier.get();
            return t;
        }
    }

    public <T> T timeCallable(Callable<T> callable) throws Exception {
        try (Timed timed = this.start();){
            T t = callable.call();
            return t;
        }
    }

    public void time(Runnable runnable) {
        try (Timed timed = this.start();){
            runnable.run();
        }
    }

    public String toString() {
        return String.format("Timer(duration=%s ns, count=%s)", this.totalDurationNs(), this.count());
    }

    private static class DefaultTimed
    implements Timed {
        private final Timer timer;
        private final long startTime;
        private boolean closed;

        private DefaultTimed(Timer timer) {
            this.timer = timer;
            this.startTime = System.nanoTime();
        }

        @Override
        public void stop() {
            if (this.closed) {
                throw new IllegalStateException("called stop() multiple times");
            }
            this.timer.record(System.nanoTime() - this.startTime);
            this.closed = true;
        }
    }

    public static interface Timed
    extends AutoCloseable {
        public static final Timed NOOP = () -> {};

        public void stop();

        @Override
        default public void close() {
            this.stop();
        }
    }
}

