/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.metrics.DeltaOperationReportImpl;
import io.delta.kernel.internal.metrics.ScanMetrics;
import io.delta.kernel.metrics.ScanMetricsResult;
import io.delta.kernel.metrics.ScanReport;
import io.delta.kernel.types.StructType;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class ScanReportImpl
extends DeltaOperationReportImpl
implements ScanReport {
    private final long tableVersion;
    private final StructType tableSchema;
    private final UUID snapshotReportUUID;
    private final Optional<Predicate> filter;
    private final StructType readSchema;
    private final Optional<Predicate> partitionPredicate;
    private final Optional<Predicate> dataSkippingFilter;
    private final boolean isFullyConsumed;
    private final ScanMetricsResult scanMetricsResult;

    public ScanReportImpl(String string, long l, StructType structType, UUID uUID, Optional<Predicate> optional, StructType structType2, Optional<Predicate> optional2, Optional<Predicate> optional3, boolean bl, ScanMetrics scanMetrics, Optional<Exception> optional4) {
        super(string, optional4);
        this.tableVersion = l;
        this.tableSchema = Objects.requireNonNull(structType);
        this.snapshotReportUUID = Objects.requireNonNull(uUID);
        this.filter = Objects.requireNonNull(optional);
        this.readSchema = Objects.requireNonNull(structType2);
        this.partitionPredicate = Objects.requireNonNull(optional2);
        this.dataSkippingFilter = Objects.requireNonNull(optional3);
        this.isFullyConsumed = bl;
        this.scanMetricsResult = Objects.requireNonNull(scanMetrics).captureScanMetricsResult();
    }

    @Override
    public long getTableVersion() {
        return this.tableVersion;
    }

    @Override
    public StructType getTableSchema() {
        return this.tableSchema;
    }

    @Override
    public UUID getSnapshotReportUUID() {
        return this.snapshotReportUUID;
    }

    @Override
    public Optional<Predicate> getFilter() {
        return this.filter;
    }

    @Override
    public StructType getReadSchema() {
        return this.readSchema;
    }

    @Override
    public Optional<Predicate> getPartitionPredicate() {
        return this.partitionPredicate;
    }

    @Override
    public Optional<Predicate> getDataSkippingFilter() {
        return this.dataSkippingFilter;
    }

    @Override
    public boolean getIsFullyConsumed() {
        return this.isFullyConsumed;
    }

    @Override
    public ScanMetricsResult getScanMetrics() {
        return this.scanMetricsResult;
    }
}

