/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.metrics.ScanReport;
import io.delta.kernel.metrics.SnapshotReport;
import io.delta.kernel.metrics.TransactionReport;
import io.delta.kernel.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import io.delta.kernel.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.delta.kernel.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.delta.kernel.types.StructType;

public final class MetricsReportSerializers {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new Jdk8Module()).registerModule(new SimpleModule().addSerializer(Exception.class, new ToStringSerializer())).registerModule(new SimpleModule().addSerializer(StructType.class, new ToStringSerializer())).registerModule(new SimpleModule().addSerializer(Predicate.class, new ToStringSerializer()));

    public static String serializeSnapshotReport(SnapshotReport snapshotReport) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(snapshotReport);
    }

    public static String serializeScanReport(ScanReport scanReport) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(scanReport);
    }

    public static String serializeTransactionReport(TransactionReport transactionReport) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(transactionReport);
    }

    private MetricsReportSerializers() {
    }
}

