/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.icebergcompat;

import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.icebergcompat.IcebergCompatMetadataValidatorAndUpdater;
import io.delta.kernel.internal.tablefeatures.TableFeature;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import io.delta.kernel.utils.DataFileStatus;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IcebergCompatV2MetadataValidatorAndUpdater
extends IcebergCompatMetadataValidatorAndUpdater {
    private static final IcebergCompatV2MetadataValidatorAndUpdater INSTANCE = new IcebergCompatV2MetadataValidatorAndUpdater();
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer ICEBERG_COMPAT_V2_CM_REQUIREMENT = new IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer<ColumnMapping.ColumnMappingMode>(TableConfig.COLUMN_MAPPING_MODE, columnMappingMode -> ColumnMapping.ColumnMappingMode.NAME == columnMappingMode || ColumnMapping.ColumnMappingMode.ID == columnMappingMode, ColumnMapping.ColumnMappingMode.NAME.value);
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck ICEBERG_COMPAT_V2_CHECK_NO_COMPAT_V1_ENABLED = icebergCompatInputContext -> {
        if (Boolean.valueOf(icebergCompatInputContext.newMetadata.getConfiguration().getOrDefault("delta.enableIcebergCompatV1", "false")).booleanValue()) {
            throw DeltaErrors.icebergCompatIncompatibleVersionEnabled(INSTANCE.compatFeatureName(), "delta.enableIcebergCompatV1");
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck ICEBERG_COMPAT_V2_CHECK_HAS_SUPPORTED_TYPES = icebergCompatInputContext -> {
        List<Tuple2<List<String>, StructField>> list = SchemaUtils.filterRecursively(icebergCompatInputContext.newMetadata.getSchema(), true, false, structField -> {
            DataType dataType = structField.getDataType();
            return !(dataType instanceof ByteType) && !(dataType instanceof ShortType) && !(dataType instanceof IntegerType) && !(dataType instanceof LongType) && !(dataType instanceof FloatType) && !(dataType instanceof DoubleType) && !(dataType instanceof DecimalType) && !(dataType instanceof StringType) && !(dataType instanceof BinaryType) && !(dataType instanceof BooleanType) && !(dataType instanceof DateType) && !(dataType instanceof TimestampType) && !(dataType instanceof TimestampNTZType) && !(dataType instanceof ArrayType) && !(dataType instanceof MapType) && !(dataType instanceof StructType);
        });
        if (!list.isEmpty()) {
            throw DeltaErrors.icebergCompatUnsupportedTypeColumns(INSTANCE.compatFeatureName(), list.stream().map(tuple2 -> ((StructField)tuple2._2).getDataType()).collect(Collectors.toList()));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck ICEBERG_COMPAT_V2_CHECK_HAS_ALLOWED_PARTITION_TYPES = icebergCompatInputContext -> icebergCompatInputContext.newMetadata.getPartitionColNames().forEach(string -> {
        boolean bl;
        int n = icebergCompatInputContext.newMetadata.getSchema().indexOf((String)string);
        Preconditions.checkArgument(n != -1, "Partition column %s not found in the schema", string);
        DataType dataType = icebergCompatInputContext.newMetadata.getSchema().at(n).getDataType();
        boolean bl2 = bl = dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType || dataType instanceof StringType || dataType instanceof BinaryType || dataType instanceof BooleanType || dataType instanceof DateType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType;
        if (!bl) {
            throw DeltaErrors.icebergCompatUnsupportedTypePartitionColumn(INSTANCE.compatFeatureName(), dataType);
        }
    });
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck ICEBERG_COMPAT_V2_CHECK_HAS_NO_PARTITION_EVOLUTION = icebergCompatInputContext -> {};
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck ICEBERG_COMPAT_V2_CHECK_HAS_NO_DELETION_VECTORS = icebergCompatInputContext -> {
        if (icebergCompatInputContext.newProtocol.supportsFeature(TableFeatures.DELETION_VECTORS_RW_FEATURE)) {
            throw DeltaErrors.icebergCompatIncompatibleTableFeatures(INSTANCE.compatFeatureName(), Collections.singleton(TableFeatures.DELETION_VECTORS_RW_FEATURE));
        }
    };
    private static final IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck ICEBERG_COMPAT_V2_CHECK_HAS_SUPPORTED_TYPE_WIDENING = icebergCompatInputContext -> {
        if (icebergCompatInputContext.newProtocol.supportsFeature(TableFeatures.TYPE_WIDENING_RW_FEATURE)) {
            throw DeltaErrors.unsupportedTableFeature(TableFeatures.TYPE_WIDENING_RW_FEATURE.featureName());
        }
        if (icebergCompatInputContext.newProtocol.supportsFeature(TableFeatures.TYPE_WIDENING_RW_PREVIEW_FEATURE)) {
            throw DeltaErrors.unsupportedTableFeature(TableFeatures.TYPE_WIDENING_RW_PREVIEW_FEATURE.featureName());
        }
    };

    public static Optional<Metadata> validateAndUpdateIcebergCompatV2Metadata(boolean bl, Metadata metadata, Protocol protocol) {
        return INSTANCE.validateAndUpdateMetadata(new IcebergCompatMetadataValidatorAndUpdater.IcebergCompatInputContext(bl, metadata, protocol));
    }

    public static void validateDataFileStatus(DataFileStatus dataFileStatus) {
        if (!dataFileStatus.getStatistics().isPresent()) {
            throw DeltaErrors.icebergCompatMissingNumRecordsStats(INSTANCE.compatFeatureName(), dataFileStatus);
        }
    }

    @Override
    String compatFeatureName() {
        return "icebergCompatV2";
    }

    @Override
    TableConfig<Boolean> requiredDeltaTableProperty() {
        return TableConfig.ICEBERG_COMPAT_V2_ENABLED;
    }

    @Override
    List<IcebergCompatMetadataValidatorAndUpdater.IcebergCompatRequiredTablePropertyEnforcer> requiredDeltaTableProperties() {
        return Collections.singletonList(ICEBERG_COMPAT_V2_CM_REQUIREMENT);
    }

    @Override
    List<TableFeature> requiredDependencyTableFeatures() {
        return Stream.of(TableFeatures.ICEBERG_COMPAT_V2_W_FEATURE, TableFeatures.COLUMN_MAPPING_RW_FEATURE).collect(Collectors.toList());
    }

    @Override
    List<IcebergCompatMetadataValidatorAndUpdater.IcebergCompatCheck> icebergCompatChecks() {
        return Stream.of(ICEBERG_COMPAT_V2_CHECK_NO_COMPAT_V1_ENABLED, ICEBERG_COMPAT_V2_CHECK_HAS_SUPPORTED_TYPES, ICEBERG_COMPAT_V2_CHECK_HAS_ALLOWED_PARTITION_TYPES, ICEBERG_COMPAT_V2_CHECK_HAS_NO_PARTITION_EVOLUTION, ICEBERG_COMPAT_V2_CHECK_HAS_NO_DELETION_VECTORS, ICEBERG_COMPAT_V2_CHECK_HAS_SUPPORTED_TYPE_WIDENING).collect(Collectors.toList());
    }
}

