/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.clustering;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.metadatadomain.JsonMetadataDomain;
import io.delta.kernel.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import io.delta.kernel.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.delta.kernel.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ClusteringMetadataDomain
extends JsonMetadataDomain {
    public static final String DOMAIN_NAME = "delta.clustering";
    @JsonProperty(value="clusteringColumns")
    private final List<List<String>> clusteringColumns;

    public static ClusteringMetadataDomain fromClusteringColumns(List<Column> list) {
        return new ClusteringMetadataDomain(list.stream().map(column -> Arrays.asList(column.getNames())).collect(Collectors.toList()));
    }

    public static ClusteringMetadataDomain fromJsonConfiguration(String string) {
        return JsonMetadataDomain.fromJsonConfiguration(string, ClusteringMetadataDomain.class);
    }

    public static Optional<ClusteringMetadataDomain> fromSnapshot(SnapshotImpl snapshotImpl) {
        return JsonMetadataDomain.fromSnapshot(snapshotImpl, ClusteringMetadataDomain.class, DOMAIN_NAME);
    }

    @JsonCreator
    private ClusteringMetadataDomain(@JsonProperty(value="clusteringColumns") List<List<String>> list) {
        this.clusteringColumns = list;
    }

    @Override
    public String getDomainName() {
        return DOMAIN_NAME;
    }

    @JsonIgnore
    public List<Column> getClusteringColumns() {
        return this.clusteringColumns.stream().map(list -> new Column(list.toArray(new String[0]))).collect(Collectors.toList());
    }
}

