/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checksum;

import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Utils;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumWriter {
    private static final Logger logger = LoggerFactory.getLogger(ChecksumWriter.class);
    private final Path logPath;

    public ChecksumWriter(Path path) {
        this.logPath = Objects.requireNonNull(path);
    }

    public void writeCheckSum(Engine engine, CRCInfo cRCInfo) throws IOException {
        Path path = FileNames.checksumFile(this.logPath, cRCInfo.getVersion());
        logger.info("Writing checksum file to path: {}", (Object)path);
        DeltaErrors.wrapEngineExceptionThrowsIO(() -> {
            engine.getJsonHandler().writeJsonFileAtomically(path.toString(), Utils.singletonCloseableIterator(cRCInfo.toRow()), false);
            logger.info("Write checksum file `{}` succeeds", (Object)path);
            return null;
        }, "Write checksum file `%s`", path);
    }
}

