/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checksum;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.data.StructRow;
import io.delta.kernel.internal.stats.FileSizeHistogram;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRCInfo {
    private static final Logger logger = LoggerFactory.getLogger(CRCInfo.class);
    private static final String TABLE_SIZE_BYTES = "tableSizeBytes";
    private static final String NUM_FILES = "numFiles";
    private static final String NUM_METADATA = "numMetadata";
    private static final String NUM_PROTOCOL = "numProtocol";
    private static final String METADATA = "metadata";
    private static final String PROTOCOL = "protocol";
    private static final String TXN_ID = "txnId";
    private static final String DOMAIN_METADATA = "domainMetadata";
    private static final String FILE_SIZE_HISTOGRAM = "fileSizeHistogram";
    public static final StructType CRC_FILE_SCHEMA = new StructType().add("tableSizeBytes", LongType.LONG).add("numFiles", LongType.LONG).add("numMetadata", LongType.LONG).add("numProtocol", LongType.LONG).add("metadata", Metadata.FULL_SCHEMA).add("protocol", Protocol.FULL_SCHEMA).add("txnId", (DataType)StringType.STRING, true).add("domainMetadata", (DataType)new ArrayType(DomainMetadata.FULL_SCHEMA, false), true).add("fileSizeHistogram", (DataType)FileSizeHistogram.FULL_SCHEMA, true);
    private final long version;
    private final Metadata metadata;
    private final Protocol protocol;
    private final long tableSizeBytes;
    private final long numFiles;
    private final Optional<String> txnId;
    private final Optional<Set<DomainMetadata>> domainMetadata;
    private final Optional<FileSizeHistogram> fileSizeHistogram;

    public static Optional<CRCInfo> fromColumnarBatch(long l, ColumnarBatch columnarBatch, int n, String string) {
        Optional<Set<DomainMetadata>> optional;
        Protocol protocol = Protocol.fromColumnVector(columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(PROTOCOL)), n);
        Metadata metadata = Metadata.fromColumnVector(columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(METADATA)), n);
        long l2 = InternalUtils.requireNonNull(columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(TABLE_SIZE_BYTES)), n, TABLE_SIZE_BYTES).getLong(n);
        long l3 = InternalUtils.requireNonNull(columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(NUM_FILES)), n, NUM_FILES).getLong(n);
        ColumnVector columnVector = columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(TXN_ID));
        Optional<String> optional2 = columnVector.isNullAt(n) ? Optional.empty() : Optional.of(columnVector.getString(n));
        Optional<FileSizeHistogram> optional3 = FileSizeHistogram.fromColumnVector(columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(FILE_SIZE_HISTOGRAM)), n);
        ColumnVector columnVector2 = columnarBatch.getColumnVector(CRCInfo.getSchemaIndex(DOMAIN_METADATA));
        Optional<Set<DomainMetadata>> optional4 = optional = columnVector2.isNullAt(n) ? Optional.empty() : Optional.of(VectorUtils.toJavaList(columnVector2.getArray(n)).stream().map(object -> DomainMetadata.fromRow((StructRow)object)).collect(Collectors.toSet()));
        if (protocol == null || metadata == null) {
            logger.warn("Invalid checksum file missing protocol and/or metadata: {}", (Object)string);
            return Optional.empty();
        }
        return Optional.of(new CRCInfo(l, metadata, protocol, l2, l3, optional2, optional, optional3));
    }

    public CRCInfo(long l, Metadata metadata, Protocol protocol, long l2, long l3, Optional<String> optional, Optional<Set<DomainMetadata>> optional2, Optional<FileSizeHistogram> optional3) {
        Preconditions.checkArgument(l2 >= 0L);
        Preconditions.checkArgument(l3 >= 0L);
        this.domainMetadata = Objects.requireNonNull(optional2);
        optional2.ifPresent(set -> set.forEach(domainMetadata -> Preconditions.checkArgument(!domainMetadata.isRemoved(), String.format("Domain metadata in CRC should exclude tombstones, found removed domain metadata: %s.", domainMetadata.getDomain()))));
        this.version = l;
        this.metadata = Objects.requireNonNull(metadata);
        this.protocol = Objects.requireNonNull(protocol);
        this.tableSizeBytes = l2;
        this.numFiles = l3;
        this.txnId = Objects.requireNonNull(optional);
        this.fileSizeHistogram = Objects.requireNonNull(optional3);
    }

    public long getVersion() {
        return this.version;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public long getNumFiles() {
        return this.numFiles;
    }

    public long getTableSizeBytes() {
        return this.tableSizeBytes;
    }

    public Optional<String> getTxnId() {
        return this.txnId;
    }

    public Optional<Set<DomainMetadata>> getDomainMetadata() {
        return this.domainMetadata;
    }

    public Optional<FileSizeHistogram> getFileSizeHistogram() {
        return this.fileSizeHistogram;
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(CRCInfo.getSchemaIndex(TABLE_SIZE_BYTES), this.tableSizeBytes);
        hashMap.put(CRCInfo.getSchemaIndex(NUM_FILES), this.numFiles);
        hashMap.put(CRCInfo.getSchemaIndex(NUM_METADATA), 1L);
        hashMap.put(CRCInfo.getSchemaIndex(NUM_PROTOCOL), 1L);
        hashMap.put(CRCInfo.getSchemaIndex(METADATA), this.metadata.toRow());
        hashMap.put(CRCInfo.getSchemaIndex(PROTOCOL), this.protocol.toRow());
        this.txnId.ifPresent(string -> hashMap.put(CRCInfo.getSchemaIndex(TXN_ID), string));
        this.domainMetadata.ifPresent(set -> hashMap.put(CRCInfo.getSchemaIndex(DOMAIN_METADATA), VectorUtils.buildArrayValue(set.stream().map(DomainMetadata::toRow).collect(Collectors.toList()), DomainMetadata.FULL_SCHEMA)));
        this.fileSizeHistogram.ifPresent(fileSizeHistogram -> hashMap.put(CRCInfo.getSchemaIndex(FILE_SIZE_HISTOGRAM), fileSizeHistogram.toRow()));
        return new GenericRow(CRC_FILE_SCHEMA, hashMap);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.metadata, this.protocol, this.tableSizeBytes, this.numFiles, this.txnId, this.domainMetadata, this.fileSizeHistogram);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CRCInfo)) {
            return false;
        }
        CRCInfo cRCInfo = (CRCInfo)object;
        return this.version == cRCInfo.version && this.tableSizeBytes == cRCInfo.tableSizeBytes && this.numFiles == cRCInfo.numFiles && this.metadata.equals(cRCInfo.metadata) && this.protocol.equals(cRCInfo.protocol) && this.txnId.equals(cRCInfo.txnId) && this.domainMetadata.equals(cRCInfo.domainMetadata) && this.fileSizeHistogram.equals(cRCInfo.fileSizeHistogram);
    }

    private static int getSchemaIndex(String string) {
        return CRC_FILE_SCHEMA.indexOf(string);
    }
}

