/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.CheckpointAlreadyExistsException;
import io.delta.kernel.exceptions.KernelEngineException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.CheckpointMetaData;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.snapshot.MetadataCleanup;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpointer {
    private static final Logger logger = LoggerFactory.getLogger(Checkpointer.class);
    private static final int READ_LAST_CHECKPOINT_FILE_MAX_RETRIES = 3;
    public static final String LAST_CHECKPOINT_FILE_NAME = "_last_checkpoint";
    private final Path lastCheckpointFilePath;

    public static void checkpoint(Engine engine, Clock clock, SnapshotImpl snapshotImpl) throws TableNotFoundException, IOException {
        Object object;
        Path path = snapshotImpl.getDataPath();
        Path path2 = snapshotImpl.getLogPath();
        long l = snapshotImpl.getVersion();
        logger.info("{}: Starting checkpoint for version: {}", (Object)path, (Object)l);
        TableFeatures.validateKernelCanWriteToTable(snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), snapshotImpl.getDataPath().toString());
        Path path3 = FileNames.checkpointFileSingular(path2, l);
        long l2 = 0L;
        try {
            object = snapshotImpl.getCreateCheckpointIterator(engine);
            try {
                DeltaErrors.wrapEngineExceptionThrowsIO(() -> Checkpointer.lambda$checkpoint$0(engine, path3, (CreateCheckpointIterator)object, path, l), "Writing checkpoint file %s", path3.toString());
                l2 = ((CreateCheckpointIterator)object).getNumberOfAddActions();
            }
            finally {
                if (object != null) {
                    ((CreateCheckpointIterator)object).close();
                }
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof FileAlreadyExistsException || iOException.getCause() instanceof FileAlreadyExistsException) {
                throw new CheckpointAlreadyExistsException(l);
            }
            throw iOException;
        }
        object = new CheckpointMetaData(l, l2, Optional.empty());
        new Checkpointer(path2).writeLastCheckpointFile(engine, (CheckpointMetaData)object);
        logger.info("{}: Finished writing last checkpoint metadata file for version: {}", (Object)path, (Object)l);
        Metadata metadata = snapshotImpl.getMetadata();
        if (TableConfig.EXPIRED_LOG_CLEANUP_ENABLED.fromMetadata(metadata).booleanValue()) {
            MetadataCleanup.cleanupExpiredLogs(engine, clock, path, TableConfig.LOG_RETENTION.fromMetadata(metadata));
        } else {
            logger.info("{}: Log cleanup is disabled. Skipping the deletion of expired log files", (Object)path);
        }
    }

    public static Optional<CheckpointInstance> getLatestCompleteCheckpointFromList(List<CheckpointInstance> list, CheckpointInstance checkpointInstance3) {
        List list2 = list.stream().filter(checkpointInstance2 -> checkpointInstance2.isNotLaterThan(checkpointInstance3)).collect(Collectors.groupingBy(checkpointInstance -> checkpointInstance)).entrySet().stream().filter(entry -> {
            CheckpointInstance checkpointInstance = (CheckpointInstance)entry.getKey();
            List list = (List)entry.getValue();
            if (checkpointInstance.numParts.isPresent()) {
                return list.size() == ((CheckpointInstance)entry.getKey()).numParts.get().intValue();
            }
            return list.size() == 1;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((CheckpointInstance)Collections.max(list2));
    }

    public static Optional<CheckpointInstance> findLastCompleteCheckpointBefore(Engine engine, Path path, long l) {
        return (Optional)Checkpointer.findLastCompleteCheckpointBeforeHelper((Engine)engine, (Path)path, (long)l)._1;
    }

    public static Tuple2<Optional<CheckpointInstance>, Long> findLastCompleteCheckpointBeforeHelper(Engine engine, Path path, long l) {
        CheckpointInstance checkpointInstance = new CheckpointInstance(l);
        logger.info("Try to find the last complete checkpoint before version {}", (Object)l);
        long l2 = 0L;
        for (long i = l; i >= 0L; i -= 1000L) {
            try {
                Object object;
                long l3 = Math.max(0L, i - 1000L);
                CloseableIterator closeableIterator = DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().listFrom(FileNames.listingPrefix(path, l3)), "Listing from %s", FileNames.listingPrefix(path, l3));
                ArrayList<CheckpointInstance> arrayList = new ArrayList<CheckpointInstance>();
                while (closeableIterator.hasNext()) {
                    boolean bl;
                    object = (FileStatus)closeableIterator.next();
                    String string = new Path(((FileStatus)object).getPath()).getName();
                    long l4 = FileNames.isCommitFile(string) ? FileNames.deltaVersion(string) : (FileNames.isCheckpointFile(string) ? FileNames.checkpointVersion(string) : i);
                    boolean bl2 = bl = (i == 0L || l4 <= i) && l4 < l;
                    if (!bl) break;
                    if (Checkpointer.validCheckpointFile((FileStatus)object)) {
                        arrayList.add(new CheckpointInstance(((FileStatus)object).getPath()));
                    }
                    ++l2;
                }
                if (!((Optional)(object = Checkpointer.getLatestCompleteCheckpointFromList(arrayList, checkpointInstance))).isPresent()) continue;
                logger.info("Found the last complete checkpoint before version {} at {}", (Object)l, ((Optional)object).get());
                return new Tuple2<Object, Long>(object, l2);
            }
            catch (IOException iOException) {
                String string = String.format("Failed to list checkpoint files for version %s in %s.", l, path);
                logger.warn(string, (Throwable)iOException);
                return new Tuple2<Optional<CheckpointInstance>, Long>(Optional.empty(), l2);
            }
        }
        logger.info("No complete checkpoint found before version {} in {}", (Object)l, (Object)path);
        return new Tuple2<Optional<CheckpointInstance>, Long>(Optional.empty(), l2);
    }

    private static boolean validCheckpointFile(FileStatus fileStatus) {
        return FileNames.isCheckpointFile(new Path(fileStatus.getPath()).getName()) && fileStatus.getSize() > 0L;
    }

    public Checkpointer(Path path) {
        this.lastCheckpointFilePath = new Path(path, LAST_CHECKPOINT_FILE_NAME);
    }

    public Optional<CheckpointMetaData> readLastCheckpointFile(Engine engine) {
        return this.loadMetadataFromFile(engine, 0);
    }

    public void writeLastCheckpointFile(Engine engine, CheckpointMetaData checkpointMetaData) throws IOException {
        DeltaErrors.wrapEngineExceptionThrowsIO(() -> {
            engine.getJsonHandler().writeJsonFileAtomically(this.lastCheckpointFilePath.toString(), Utils.singletonCloseableIterator(checkpointMetaData.toRow()), true);
            return null;
        }, "Writing last checkpoint file at `%s`", this.lastCheckpointFilePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<CheckpointMetaData> loadMetadataFromFile(Engine engine, int n) {
        if (n >= 3) {
            logger.warn("Failed to load checkpoint metadata from file {} after {} attempts.", (Object)this.lastCheckpointFilePath, (Object)3);
            return Optional.empty();
        }
        logger.info("Loading last checkpoint from the _last_checkpoint file. Attempt: {} / {}", (Object)(n + 1), (Object)3);
        try {
            FileStatus fileStatus = FileStatus.of(this.lastCheckpointFilePath.toString(), 0L, 0L);
            try (CloseableIterator closeableIterator = DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), CheckpointMetaData.READ_SCHEMA, Optional.empty()), "Reading the last checkpoint file as JSON", new Object[0]);){
                Optional<Row> optional = InternalUtils.getSingularRow(closeableIterator);
                if (optional.isPresent()) {
                    Optional<CheckpointMetaData> optional2 = Optional.of(CheckpointMetaData.fromRow(optional.get()));
                    return optional2;
                }
                logger.warn("Last checkpoint file {} has no data. Retrying after 1sec. (current attempt = {})", (Object)this.lastCheckpointFilePath, (Object)n);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Optional<CheckpointMetaData> optional3 = Optional.empty();
                    if (closeableIterator == null) return optional3;
                    closeableIterator.close();
                    return optional3;
                }
                Optional<CheckpointMetaData> optional4 = this.loadMetadataFromFile(engine, n + 1);
                return optional4;
            }
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) return Optional.empty();
            if (exception instanceof KernelEngineException && exception.getCause() instanceof FileNotFoundException) {
                return Optional.empty();
            }
            String string = String.format("Failed to load checkpoint metadata from file %s. It must be in the process of being written. Retrying after 1sec. (current attempt of %s (max 3)", this.lastCheckpointFilePath, n);
            logger.warn(string, (Throwable)exception);
            return this.loadMetadataFromFile(engine, n + 1);
        }
    }

    private static /* synthetic */ Object lambda$checkpoint$0(Engine engine, Path path, CreateCheckpointIterator createCheckpointIterator, Path path2, long l) throws IOException {
        engine.getParquetHandler().writeParquetFileAtomically(path.toString(), createCheckpointIterator);
        logger.info("{}: Finished writing checkpoint file for version: {}", (Object)path2, (Object)l);
        return null;
    }
}

