/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;

public class DomainMetadata {
    public static final StructType FULL_SCHEMA = new StructType().add("domain", (DataType)StringType.STRING, false).add("configuration", (DataType)StringType.STRING, false).add("removed", (DataType)BooleanType.BOOLEAN, false);
    private final String domain;
    private final String configuration;
    private final boolean removed;

    public static boolean isUserControlledDomain(String string) {
        return !string.toLowerCase(Locale.ROOT).startsWith("delta.");
    }

    public static DomainMetadata fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        return new DomainMetadata(InternalUtils.requireNonNull(columnVector.getChild(0), n, "domain").getString(n), InternalUtils.requireNonNull(columnVector.getChild(1), n, "configuration").getString(n), InternalUtils.requireNonNull(columnVector.getChild(2), n, "removed").getBoolean(n));
    }

    public static DomainMetadata fromRow(Row row) {
        if (row == null) {
            return null;
        }
        Preconditions.checkArgument(row.getSchema().equals(FULL_SCHEMA), "Expected schema: %s, found: %s", FULL_SCHEMA, row.getSchema());
        return new DomainMetadata(InternalUtils.requireNonNull(row, 0, "domain").getString(0), InternalUtils.requireNonNull(row, 1, "configuration").getString(1), InternalUtils.requireNonNull(row, 2, "removed").getBoolean(2));
    }

    public DomainMetadata(String string, String string2, boolean bl) {
        this.domain = Objects.requireNonNull(string, "domain is null");
        this.configuration = Objects.requireNonNull(string2, "configuration is null");
        this.removed = bl;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, this.domain);
        hashMap.put(1, this.configuration);
        hashMap.put(2, this.removed);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public DomainMetadata removed() {
        Preconditions.checkArgument(!this.removed, "Cannot remove a domain metadata tombstone (already removed)");
        return new DomainMetadata(this.domain, this.configuration, true);
    }

    public String toString() {
        return String.format("DomainMetadata{domain='%s', configuration='%s', removed='%b'}", this.domain, this.configuration, this.removed);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DomainMetadata domainMetadata = (DomainMetadata)object;
        return this.removed == domainMetadata.removed && this.domain.equals(domainMetadata.domain) && this.configuration.equals(domainMetadata.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.configuration, this.removed);
    }
}

