/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Transaction;
import io.delta.kernel.TransactionBuilder;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.exceptions.TableAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.ReplaceTableTransactionBuilderImpl;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.TableImpl;
import io.delta.kernel.internal.TransactionImpl;
import io.delta.kernel.internal.actions.Format;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.clustering.ClusteringUtils;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.icebergcompat.IcebergCompatV2MetadataValidatorAndUpdater;
import io.delta.kernel.internal.icebergcompat.IcebergUniversalFormatMetadataValidatorAndUpdater;
import io.delta.kernel.internal.icebergcompat.IcebergWriterCompatV1MetadataValidatorAndUpdater;
import io.delta.kernel.internal.metrics.SnapshotMetrics;
import io.delta.kernel.internal.metrics.SnapshotQueryContext;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.rowtracking.MaterializedRowTrackingColumn;
import io.delta.kernel.internal.rowtracking.RowTracking;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.internal.tablefeatures.TableFeature;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.SchemaUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBuilderImpl
implements TransactionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionBuilderImpl.class);
    private final long currentTimeMillis = System.currentTimeMillis();
    private final String engineInfo;
    private final Operation operation;
    private Optional<List<String>> partitionColumns = Optional.empty();
    private Optional<SetTransaction> setTxnOpt = Optional.empty();
    private Optional<Map<String, String>> tableProperties = Optional.empty();
    private Optional<Set<String>> unsetTablePropertiesKeys = Optional.empty();
    private boolean needDomainMetadataSupport = false;
    private Optional<List<Column>> initialClusteringColumns = Optional.empty();
    private Optional<List<Column>> resolvedClusteringColumns = Optional.empty();
    protected final TableImpl table;
    protected Optional<StructType> schema = Optional.empty();
    private int maxRetries = 200;
    private int logCompactionInterval = 0;

    public TransactionBuilderImpl(TableImpl tableImpl, String string, Operation operation) {
        this.table = tableImpl;
        this.engineInfo = string;
        this.operation = operation;
    }

    @Override
    public TransactionBuilder withSchema(Engine engine, StructType structType) {
        this.schema = Optional.of(structType);
        return this;
    }

    @Override
    public TransactionBuilder withPartitionColumns(Engine engine, List<String> list) {
        if (!list.isEmpty()) {
            this.partitionColumns = Optional.of(list);
        }
        return this;
    }

    @Override
    public TransactionBuilder withClusteringColumns(Engine engine, List<Column> list) {
        this.initialClusteringColumns = Optional.of(list);
        return this;
    }

    @Override
    public TransactionBuilder withTransactionId(Engine engine, String string, long l) {
        SetTransaction setTransaction = new SetTransaction(Objects.requireNonNull(string, "applicationId is null"), l, Optional.of(this.currentTimeMillis));
        this.setTxnOpt = Optional.of(setTransaction);
        return this;
    }

    @Override
    public TransactionBuilder withTableProperties(Engine engine, Map<String, String> map) {
        this.tableProperties = Optional.of(Collections.unmodifiableMap(TableConfig.validateDeltaProperties(map)));
        return this;
    }

    @Override
    public TransactionBuilder withTablePropertiesRemoved(Set<String> set) {
        Preconditions.checkArgument(set.stream().noneMatch(string -> string.toLowerCase(Locale.ROOT).startsWith("delta.")), "Unsetting 'delta.' table properties is currently unsupported");
        this.unsetTablePropertiesKeys = Optional.of(Collections.unmodifiableSet(set));
        return this;
    }

    @Override
    public TransactionBuilder withMaxRetries(int n) {
        Preconditions.checkArgument(n >= 0, "maxRetries must be >= 0");
        this.maxRetries = n;
        return this;
    }

    @Override
    public TransactionBuilder withLogCompactionInverval(int n) {
        Preconditions.checkArgument(n >= 0, "logCompactionInterval must be >= 0");
        this.logCompactionInterval = n;
        return this;
    }

    @Override
    public TransactionBuilder withDomainMetadataSupported() {
        this.needDomainMetadataSupport = true;
        return this;
    }

    @Override
    public Transaction build(Engine engine) {
        if (this.operation == Operation.REPLACE_TABLE) {
            throw new UnsupportedOperationException("REPLACE TABLE is not yet supported");
        }
        try {
            SnapshotImpl snapshotImpl = (SnapshotImpl)this.table.getLatestSnapshot(engine);
            if (this.operation == Operation.CREATE_TABLE) {
                throw new TableAlreadyExistsException(this.table.getPath(engine), "Operation = CREATE_TABLE");
            }
            return this.buildTransactionInternal(engine, false, Optional.of(snapshotImpl));
        }
        catch (TableNotFoundException tableNotFoundException) {
            String string = this.table.getPath(engine);
            logger.info("Table {} doesn't exist yet. Trying to create a new table.", (Object)string);
            this.schema.orElseThrow(() -> DeltaErrors.requiresSchemaForNewTable(string));
            return this.buildTransactionInternal(engine, true, Optional.empty());
        }
    }

    protected TransactionImpl buildTransactionInternal(Engine engine, boolean bl, Optional<SnapshotImpl> optional) {
        Object object;
        Metadata metadata;
        boolean bl2;
        Preconditions.checkArgument(bl || optional.isPresent(), "Existing snapshot must be provided if not defining a new table definition");
        optional.ifPresent(snapshotImpl -> this.validateWriteToExistingTable(engine, (SnapshotImpl)snapshotImpl, bl));
        this.validateTransactionInputs(engine, bl);
        if (!bl && this.schema.isPresent()) {
            throw new UnsupportedOperationException("Schema can only be provided for new tables. Evolution is not currently supported");
        }
        boolean bl3 = this.needDomainMetadataSupport && optional.isPresent() && !optional.get().getProtocol().supportsFeature(TableFeatures.DOMAIN_METADATA_W_FEATURE);
        boolean bl4 = bl2 = bl || this.schema.isPresent() || this.tableProperties.isPresent() || this.unsetTablePropertiesKeys.isPresent() || this.initialClusteringColumns.isPresent() || bl3;
        if (!bl2) {
            new TransactionImpl(false, this.table.getDataPath(), this.table.getLogPath(), optional.get(), this.engineInfo, this.operation, optional.get().getProtocol(), optional.get().getMetadata(), this.setTxnOpt, Optional.empty(), false, false, this.maxRetries, this.logCompactionInterval, this.table.getClock());
        }
        if (bl) {
            metadata = this.getInitialMetadata();
            if (optional.isPresent()) {
                object = optional.get().getMetadata().getConfiguration().entrySet().stream().filter(entry -> ReplaceTableTransactionBuilderImpl.TABLE_PROPERTY_KEYS_TO_PRESERVE.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                metadata = metadata.withMergedConfiguration((Map<String, String>)object);
            }
        } else {
            metadata = optional.get().getMetadata();
        }
        Protocol protocol = optional.isPresent() ? optional.get().getProtocol() : this.getInitialProtocol();
        object = bl || this.initialClusteringColumns.isPresent() ? Optional.empty() : ClusteringUtils.getClusteringColumnsOptional(optional.get());
        Tuple2<Optional<Protocol>, Optional<Metadata>> tuple2 = this.validateAndUpdateProtocolAndMetadata(engine, metadata, protocol, bl, (Optional<List<Column>>)object, optional);
        Optional optional2 = (Optional)tuple2._1;
        Optional optional3 = (Optional)tuple2._2;
        if (!optional.isPresent()) {
            optional = Optional.of(this.getInitialEmptySnapshot(engine, metadata, protocol));
        }
        if (this.operation == Operation.REPLACE_TABLE && optional2.orElse(protocol).supportsFeature(TableFeatures.ROW_TRACKING_W_FEATURE)) {
            throw new UnsupportedOperationException("REPLACE TABLE is not yet supported on row tracking tables");
        }
        return new TransactionImpl(bl, this.table.getDataPath(), this.table.getLogPath(), optional.get(), this.engineInfo, this.operation, optional2.orElse(protocol), optional3.orElse(metadata), this.setTxnOpt, this.resolvedClusteringColumns, optional3.isPresent() || bl, optional2.isPresent() || bl, this.maxRetries, this.logCompactionInterval, this.table.getClock());
    }

    protected Tuple2<Optional<Protocol>, Optional<Metadata>> validateAndUpdateProtocolAndMetadata(Engine engine, Metadata metadata, Protocol protocol, boolean bl, Optional<List<Column>> optional, Optional<SnapshotImpl> optional2) {
        Optional<Metadata> optional3;
        Optional<Metadata> optional4;
        Optional<Tuple2<Protocol, Set<TableFeature>>> optional5;
        if (bl) {
            Preconditions.checkArgument(!optional.isPresent());
        }
        Optional<Object> optional6 = Optional.empty();
        Optional<Object> optional7 = Optional.empty();
        Map<String, String> map = metadata.filterOutUnchangedProperties(this.tableProperties.orElse(Collections.emptyMap()));
        if (!map.isEmpty()) {
            optional6 = Optional.of(metadata.withMergedConfiguration(map));
        }
        if (this.unsetTablePropertiesKeys.isPresent()) {
            optional6 = Optional.of(optional6.orElse(metadata).withConfigurationKeysUnset(this.unsetTablePropertiesKeys.get()));
        }
        if (this.schema.isPresent() && !bl) {
            optional6 = Optional.of(((Metadata)optional6.orElse(metadata)).withNewSchema(this.schema.get()));
        }
        HashSet<TableFeature> hashSet = new HashSet<TableFeature>();
        if (this.needDomainMetadataSupport) {
            hashSet.add(TableFeatures.DOMAIN_METADATA_W_FEATURE);
        }
        if (this.initialClusteringColumns.isPresent()) {
            hashSet.add(TableFeatures.CLUSTERING_W_FEATURE);
        }
        Tuple2<Set<TableFeature>, Optional<Metadata>> tuple2 = TableFeatures.extractFeaturePropertyOverrides((Metadata)optional6.orElse(metadata));
        hashSet.addAll((Collection)tuple2._1);
        if (((Optional)tuple2._2).isPresent()) {
            optional6 = (Optional)tuple2._2;
        }
        if ((optional5 = TableFeatures.autoUpgradeProtocolBasedOnMetadata((Metadata)optional6.orElse(metadata), hashSet, protocol)).isPresent()) {
            logger.info("Automatically enabling table features: {}", ((Set)optional5.get()._2).stream().map(TableFeature::featureName).collect(Collectors.toSet()));
            optional7 = Optional.of((Protocol)optional5.get()._1);
            TableFeatures.validateKernelCanWriteToTable(optional7.orElse(protocol), (Metadata)optional6.orElse(metadata), this.table.getPath(engine));
        }
        optional6.ifPresent(metadata2 -> IcebergWriterCompatV1MetadataValidatorAndUpdater.validateIcebergWriterCompatV1Change(metadata.getConfiguration(), metadata2.getConfiguration(), bl));
        Optional<Metadata> optional8 = IcebergWriterCompatV1MetadataValidatorAndUpdater.validateAndUpdateIcebergWriterCompatV1Metadata(bl, (Metadata)optional6.orElse(metadata), optional7.orElse(protocol));
        if (optional8.isPresent()) {
            optional6 = optional8;
        }
        if ((optional4 = IcebergCompatV2MetadataValidatorAndUpdater.validateAndUpdateIcebergCompatV2Metadata(bl, (Metadata)optional6.orElse(metadata), (Protocol)optional7.orElse(protocol))).isPresent()) {
            optional6 = optional4;
        }
        if ((optional3 = ColumnMapping.updateColumnMappingMetadataIfNeeded((Metadata)optional6.orElse(metadata), bl)).isPresent()) {
            optional6 = optional3;
        }
        StructType structType = ((Metadata)optional6.orElse(metadata)).getSchema();
        this.resolvedClusteringColumns = this.initialClusteringColumns.map(list -> SchemaUtils.casePreservingEligibleClusterColumns(structType, list));
        Optional<Metadata> optional9 = this.validateAndUpdateRowTrackingMetadata(bl, metadata, optional6, this.table.getPath(engine));
        if (optional9.isPresent()) {
            optional6 = optional9;
        }
        if (optional6.isPresent()) {
            Optional<List<Column>> optional10 = this.resolvedClusteringColumns.isPresent() ? this.resolvedClusteringColumns : optional;
            this.validateMetadataChange(optional10, metadata, (Metadata)optional6.get(), bl, optional2);
        }
        return new Tuple2<Optional<Protocol>, Optional<Metadata>>(optional7, optional6);
    }

    protected void validateWriteToExistingTable(Engine engine, SnapshotImpl snapshotImpl, boolean bl) {
        TableFeatures.validateKernelCanWriteToTable(snapshotImpl.getProtocol(), snapshotImpl.getMetadata(), this.table.getPath(engine));
        this.setTxnOpt.ifPresent(setTransaction -> {
            Optional<Long> optional = snapshotImpl.getLatestTransactionVersion(engine, setTransaction.getAppId());
            if (optional.isPresent() && optional.get() >= setTransaction.getVersion()) {
                throw DeltaErrors.concurrentTransaction(setTransaction.getAppId(), setTransaction.getVersion(), optional.get());
            }
        });
        if (!bl && this.initialClusteringColumns.isPresent() && snapshotImpl.getMetadata().getPartitionColumns().getSize() != 0) {
            throw DeltaErrors.enablingClusteringOnPartitionedTableNotAllowed(this.table.getPath(engine), snapshotImpl.getMetadata().getPartitionColNames(), this.initialClusteringColumns.get());
        }
    }

    protected void validateTransactionInputs(Engine engine, boolean bl) {
        Object object;
        String string2 = this.table.getPath(engine);
        if (!bl) {
            if (this.partitionColumns.isPresent()) {
                throw DeltaErrors.tableAlreadyExists(string2, "Table already exists, but provided new partition columns. Partition columns can only be set on a new table.");
            }
        } else {
            Preconditions.checkArgument(!this.partitionColumns.isPresent() || !this.initialClusteringColumns.isPresent(), "Partition Columns and Clustering Columns cannot be set at the same time");
            object = ColumnMapping.getColumnMappingMode(this.tableProperties.orElse(Collections.emptyMap()));
            SchemaUtils.validateSchema(this.schema.get(), ColumnMapping.isColumnMappingModeEnabled((ColumnMapping.ColumnMappingMode)((Object)object)));
            SchemaUtils.validatePartitionColumns(this.schema.get(), this.partitionColumns.orElse(Collections.emptyList()));
        }
        if (this.unsetTablePropertiesKeys.isPresent() && this.tableProperties.isPresent() && !(object = this.unsetTablePropertiesKeys.get().stream().filter(string -> this.tableProperties.get().containsKey(string)).collect(Collectors.toSet())).isEmpty()) {
            throw DeltaErrors.overlappingTablePropertiesSetAndUnset((Set<String>)object);
        }
    }

    private void validateMetadataChange(Optional<List<Column>> optional, Metadata metadata, Metadata metadata2, boolean bl, Optional<SnapshotImpl> optional2) {
        ColumnMapping.ColumnMappingMode columnMappingMode;
        ColumnMapping.ColumnMappingMode columnMappingMode2;
        ColumnMapping.verifyColumnMappingChange(metadata.getConfiguration(), metadata2.getConfiguration(), bl);
        IcebergWriterCompatV1MetadataValidatorAndUpdater.validateIcebergWriterCompatV1Change(metadata.getConfiguration(), metadata2.getConfiguration(), bl);
        IcebergUniversalFormatMetadataValidatorAndUpdater.validate(metadata2);
        if (this.schema.isPresent() && !bl) {
            columnMappingMode2 = ColumnMapping.getColumnMappingMode(metadata2.getConfiguration());
            columnMappingMode = ColumnMapping.getColumnMappingMode(metadata.getConfiguration());
            if (columnMappingMode != columnMappingMode2) {
                throw new KernelException("Cannot update mapping mode and perform schema evolution");
            }
            if (!ColumnMapping.isColumnMappingModeEnabled(columnMappingMode2)) {
                throw new KernelException("Cannot update schema for table when column mapping is disabled");
            }
            Set<String> set = optional.orElse(Collections.emptyList()).stream().map(column -> column.getNames()[column.getNames().length - 1]).collect(Collectors.toSet());
            SchemaUtils.validateUpdatedSchema(metadata, metadata2, set, false);
        }
        if (bl && optional2.isPresent()) {
            columnMappingMode2 = ColumnMapping.getColumnMappingMode(optional2.get().getMetadata().getConfiguration());
            if (columnMappingMode2 != (columnMappingMode = ColumnMapping.getColumnMappingMode(metadata2.getConfiguration()))) {
                throw new UnsupportedOperationException(String.format("Changing column mapping mode from %s to %s is not currently supported in Kernel during REPLACE TABLE operations", new Object[]{columnMappingMode2, columnMappingMode}));
            }
            if (columnMappingMode != ColumnMapping.ColumnMappingMode.NONE) {
                SchemaUtils.validateUpdatedSchema(optional2.get().getMetadata(), metadata2, Collections.emptySet(), true);
            }
        }
        MaterializedRowTrackingColumn.throwIfColumnNamesConflictWithSchema(metadata2);
    }

    private SnapshotImpl getInitialEmptySnapshot(Engine engine, Metadata metadata, Protocol protocol) {
        SnapshotQueryContext snapshotQueryContext = SnapshotQueryContext.forVersionSnapshot(this.table.getPath(engine), -1L);
        LogReplay logReplay = this.getEmptyLogReplay(engine, metadata, protocol, snapshotQueryContext.getSnapshotMetrics());
        return new InitialSnapshot(this.table.getDataPath(), logReplay, metadata, protocol, snapshotQueryContext);
    }

    private LogReplay getEmptyLogReplay(Engine engine, final Metadata metadata, final Protocol protocol, SnapshotMetrics snapshotMetrics) {
        return new LogReplay(this.table.getLogPath(), this.table.getDataPath(), engine, LogSegment.empty(this.table.getLogPath()), Optional.empty(), snapshotMetrics){

            @Override
            protected Tuple2<Protocol, Metadata> loadTableProtocolAndMetadata(Engine engine, LogSegment logSegment, Optional<SnapshotHint> optional, long l) {
                return new Tuple2<Protocol, Metadata>(protocol, metadata);
            }

            @Override
            public Optional<Long> getLatestTransactionIdentifier(Engine engine, String string) {
                return Optional.empty();
            }
        };
    }

    private Metadata getInitialMetadata() {
        List<String> list = SchemaUtils.casePreservingPartitionColNames(this.schema.get(), this.partitionColumns.orElse(Collections.emptyList()));
        return new Metadata(UUID.randomUUID().toString(), Optional.empty(), Optional.empty(), new Format(), this.schema.get().toJson(), this.schema.get(), VectorUtils.buildArrayValue(list, StringType.STRING), Optional.of(this.currentTimeMillis), VectorUtils.stringStringMapValue(Collections.emptyMap()));
    }

    private Protocol getInitialProtocol() {
        return new Protocol(1, 2);
    }

    private Optional<Metadata> validateAndUpdateRowTrackingMetadata(boolean bl, Metadata metadata, Optional<Metadata> optional, String string) {
        Optional<Metadata> optional2 = Optional.empty();
        if (bl) {
            optional2 = MaterializedRowTrackingColumn.assignMaterializedColumnNamesIfNeeded(optional.orElse(metadata));
        } else {
            optional.ifPresent(metadata2 -> RowTracking.throwIfRowTrackingToggled(metadata, metadata2));
            MaterializedRowTrackingColumn.validateRowTrackingConfigsNotMissing(optional.orElse(metadata), string);
        }
        return optional2;
    }

    private class InitialSnapshot
    extends SnapshotImpl {
        InitialSnapshot(Path path, LogReplay logReplay, Metadata metadata, Protocol protocol, SnapshotQueryContext snapshotQueryContext) {
            super(path, LogSegment.empty(TransactionBuilderImpl.this.table.getLogPath()), logReplay, protocol, metadata, snapshotQueryContext);
        }

        @Override
        public long getTimestamp(Engine engine) {
            return -1L;
        }
    }
}

