/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Snapshot;
import io.delta.kernel.Table;
import io.delta.kernel.TransactionBuilder;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.CheckpointAlreadyExistsException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaHistoryManager;
import io.delta.kernel.internal.DeltaLogActionUtils;
import io.delta.kernel.internal.ReplaceTableTransactionBuilderImpl;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TransactionBuilderImpl;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.checkpoints.Checkpointer;
import io.delta.kernel.internal.checksum.ChecksumUtils;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.metrics.SnapshotQueryContext;
import io.delta.kernel.internal.metrics.SnapshotReportImpl;
import io.delta.kernel.internal.snapshot.SnapshotManager;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.metrics.SnapshotReport;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableImpl
implements Table {
    private static final Logger logger = LoggerFactory.getLogger(TableImpl.class);
    private final String tablePath;
    private final Checkpointer checkpointer;
    private final SnapshotManager snapshotManager;
    private final Clock clock;

    public static Table forPath(Engine engine, String string) {
        return TableImpl.forPath(engine, string, System::currentTimeMillis);
    }

    public static Table forPath(Engine engine, String string, Clock clock) {
        String string2;
        try {
            string2 = DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().resolvePath(string), "Resolving path %s", string);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return new TableImpl(string2, clock);
    }

    public TableImpl(String string, Clock clock) {
        this.tablePath = string;
        Path path = new Path(string);
        Path path2 = new Path(path, "_delta_log");
        this.checkpointer = new Checkpointer(path2);
        this.snapshotManager = new SnapshotManager(path);
        this.clock = clock;
    }

    @Override
    public String getPath(Engine engine) {
        return this.tablePath;
    }

    @Override
    public Snapshot getLatestSnapshot(Engine engine) throws TableNotFoundException {
        SnapshotQueryContext snapshotQueryContext = SnapshotQueryContext.forLatestSnapshot(this.tablePath);
        try {
            return this.snapshotManager.buildLatestSnapshot(engine, snapshotQueryContext);
        }
        catch (Exception exception) {
            this.recordSnapshotErrorReport(engine, snapshotQueryContext, exception);
            throw exception;
        }
    }

    @Override
    public Snapshot getSnapshotAsOfVersion(Engine engine, long l) throws TableNotFoundException {
        SnapshotQueryContext snapshotQueryContext = SnapshotQueryContext.forVersionSnapshot(this.tablePath, l);
        try {
            return this.snapshotManager.getSnapshotAt(engine, l, snapshotQueryContext);
        }
        catch (Exception exception) {
            this.recordSnapshotErrorReport(engine, snapshotQueryContext, exception);
            throw exception;
        }
    }

    @Override
    public Snapshot getSnapshotAsOfTimestamp(Engine engine, long l) throws TableNotFoundException {
        SnapshotQueryContext snapshotQueryContext = SnapshotQueryContext.forTimestampSnapshot(this.tablePath, l);
        try {
            return this.snapshotManager.getSnapshotForTimestamp(engine, l, snapshotQueryContext);
        }
        catch (Exception exception) {
            this.recordSnapshotErrorReport(engine, snapshotQueryContext, exception);
            throw exception;
        }
    }

    @Override
    public void checkpoint(Engine engine, long l) throws TableNotFoundException, CheckpointAlreadyExistsException, IOException {
        SnapshotImpl snapshotImpl = (SnapshotImpl)this.getSnapshotAsOfVersion(engine, l);
        Checkpointer.checkpoint(engine, this.clock, snapshotImpl);
    }

    @Override
    public void checksum(Engine engine, long l) throws TableNotFoundException, IOException {
        SnapshotImpl snapshotImpl = (SnapshotImpl)this.getSnapshotAsOfVersion(engine, l);
        ChecksumUtils.computeStateAndWriteChecksum(engine, snapshotImpl);
    }

    @Override
    public TransactionBuilder createTransactionBuilder(Engine engine, String string, Operation operation) {
        return new TransactionBuilderImpl(this, string, operation);
    }

    public TransactionBuilder createReplaceTableTransactionBuilder(Engine engine, String string) {
        return new ReplaceTableTransactionBuilderImpl(this, string);
    }

    public Clock getClock() {
        return this.clock;
    }

    public CloseableIterator<ColumnarBatch> getChanges(Engine engine, long l, long l2, Set<DeltaLogActionUtils.DeltaAction> set) {
        HashSet<DeltaLogActionUtils.DeltaAction> hashSet = new HashSet<DeltaLogActionUtils.DeltaAction>(set);
        hashSet.add(DeltaLogActionUtils.DeltaAction.PROTOCOL);
        hashSet.add(DeltaLogActionUtils.DeltaAction.COMMITINFO);
        boolean bl = !set.contains((Object)DeltaLogActionUtils.DeltaAction.PROTOCOL);
        boolean bl2 = !set.contains((Object)DeltaLogActionUtils.DeltaAction.COMMITINFO);
        return this.getRawChanges(engine, l, l2, hashSet).map(columnarBatch -> {
            int n = columnarBatch.getSchema().indexOf("protocol");
            ColumnVector columnVector = columnarBatch.getColumnVector(n);
            for (int i = 0; i < columnVector.getSize(); ++i) {
                if (columnVector.isNullAt(i)) continue;
                Protocol protocol = Protocol.fromColumnVector(columnVector, i);
                TableFeatures.validateKernelCanReadTheTable(protocol, this.getDataPath().toString());
            }
            ColumnarBatch columnarBatch2 = columnarBatch;
            if (bl) {
                columnarBatch2 = columnarBatch2.withDeletedColumnAt(n);
            }
            int n2 = columnarBatch2.getSchema().indexOf("commitInfo");
            if (bl2) {
                columnarBatch2 = columnarBatch2.withDeletedColumnAt(n2);
            }
            return columnarBatch2;
        });
    }

    protected Path getDataPath() {
        return new Path(this.tablePath);
    }

    protected Path getLogPath() {
        return new Path(this.tablePath, "_delta_log");
    }

    public long getVersionBeforeOrAtTimestamp(Engine engine, long l) {
        return DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.getLogPath(), l, false, true, false).getVersion();
    }

    public long getVersionAtOrAfterTimestamp(Engine engine, long l) {
        DeltaHistoryManager.Commit commit = DeltaHistoryManager.getActiveCommitAtTimestamp(engine, this.getLogPath(), l, false, false, true);
        if (commit.getTimestamp() >= l) {
            return commit.getVersion();
        }
        return commit.getVersion() + 1L;
    }

    private CloseableIterator<ColumnarBatch> getRawChanges(Engine engine, long l, long l2, Set<DeltaLogActionUtils.DeltaAction> set) {
        logger.info("{}: Getting the commit files for versions [{}, {}]", new Object[]{this.tablePath, l, l2});
        List<FileStatus> list = DeltaLogActionUtils.getCommitFilesForVersionRange(engine, new Path(this.tablePath), l, l2);
        StructType structType = new StructType(set.stream().map(deltaAction -> new StructField(deltaAction.colName, deltaAction.schema, true)).collect(Collectors.toList()));
        logger.info("{}: Reading the commit files with readSchema {}", (Object)this.tablePath, (Object)structType);
        return DeltaLogActionUtils.readCommitFiles(engine, list, structType);
    }

    private void recordSnapshotErrorReport(Engine engine, SnapshotQueryContext snapshotQueryContext, Exception exception) {
        SnapshotReport snapshotReport = SnapshotReportImpl.forError(snapshotQueryContext, exception);
        engine.getMetricsReporters().forEach(metricsReporter -> metricsReporter.report(snapshotReport));
    }
}

