/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.PredicateEvaluator;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.metrics.ScanMetrics;
import io.delta.kernel.internal.metrics.ScanReportImpl;
import io.delta.kernel.internal.metrics.Timer;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.skipping.DataSkippingPredicate;
import io.delta.kernel.internal.skipping.DataSkippingUtils;
import io.delta.kernel.internal.skipping.StatsSchemaHelper;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.metrics.SnapshotReport;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ScanImpl
implements Scan {
    private final StructType snapshotSchema;
    private final StructType readSchema;
    private final Protocol protocol;
    private final Metadata metadata;
    private final LogReplay logReplay;
    private final Path dataPath;
    private final Optional<Predicate> filter;
    private final Optional<Tuple2<Predicate, Predicate>> partitionAndDataFilters;
    private final Supplier<Map<String, StructField>> partitionColToStructFieldMap;
    private boolean accessedScanFiles;
    private final SnapshotReport snapshotReport;
    private final ScanMetrics scanMetrics = new ScanMetrics();

    public ScanImpl(StructType structType, StructType structType2, Protocol protocol, Metadata metadata, LogReplay logReplay, Optional<Predicate> optional, Path path, SnapshotReport snapshotReport) {
        this.snapshotSchema = structType;
        this.readSchema = structType2;
        this.protocol = protocol;
        this.metadata = metadata;
        this.logReplay = logReplay;
        this.filter = optional;
        this.partitionAndDataFilters = this.splitFilters(optional);
        this.dataPath = path;
        this.partitionColToStructFieldMap = () -> {
            Set<String> set = metadata.getPartitionColNames();
            return metadata.getSchema().fields().stream().filter(structField -> set.contains(structField.getName().toLowerCase(Locale.ROOT))).collect(Collectors.toMap(structField -> structField.getName().toLowerCase(Locale.ROOT), Function.identity()));
        };
        this.snapshotReport = snapshotReport;
    }

    @Override
    public CloseableIterator<FilteredColumnarBatch> getScanFiles(Engine engine) {
        return this.getScanFiles(engine, false);
    }

    public CloseableIterator<FilteredColumnarBatch> getScanFiles(Engine engine, boolean bl2) {
        if (this.accessedScanFiles) {
            throw new IllegalStateException("Scan files are already fetched from this instance");
        }
        this.accessedScanFiles = true;
        Optional<DataSkippingPredicate> optional = this.getDataSkippingFilter();
        boolean bl3 = optional.isPresent();
        boolean bl4 = bl3 || bl2;
        Timer.Timed timed = this.scanMetrics.totalPlanningTimer.start();
        ScanReportReporter scanReportReporter = (optional2, bl) -> {
            timed.stop();
            ScanReportImpl scanReportImpl = new ScanReportImpl(this.dataPath.toString(), this.logReplay.getVersion(), this.snapshotSchema, this.snapshotReport.getReportUUID(), this.filter, this.readSchema, this.getPartitionsFilters(), optional.map(dataSkippingPredicate -> dataSkippingPredicate), bl, this.scanMetrics, optional2);
            engine.getMetricsReporters().forEach(metricsReporter -> metricsReporter.report(scanReportImpl));
        };
        try {
            CloseableIterator<FilteredColumnarBatch> closeableIterator = this.logReplay.getAddFilesAsColumnarBatches(engine, bl4, this.getPartitionsFilters().map(predicate -> PartitionUtils.rewritePartitionPredicateOnCheckpointFileSchema(predicate, this.partitionColToStructFieldMap.get())), this.scanMetrics);
            closeableIterator = this.applyPartitionPruning(engine, closeableIterator);
            if (bl3) {
                closeableIterator = this.applyDataSkipping(engine, closeableIterator, optional.get());
            }
            return this.wrapWithMetricsReporting(closeableIterator, scanReportReporter);
        }
        catch (Exception exception) {
            scanReportReporter.reportError(exception);
            throw exception;
        }
    }

    @Override
    public Row getScanState(Engine engine) {
        StructType structType = ColumnMapping.convertToPhysicalSchema(this.readSchema, this.snapshotSchema, ColumnMapping.getColumnMappingMode(this.metadata.getConfiguration()));
        List list = VectorUtils.toJavaList(this.metadata.getPartitionColumns());
        StructType structType2 = PartitionUtils.physicalSchemaWithoutPartitionColumns(this.readSchema, structType, new HashSet<String>(list));
        if (this.protocol.getReaderFeatures().contains("deletionVectors")) {
            structType2 = structType2.add(StructField.METADATA_ROW_INDEX_COLUMN);
        }
        return ScanStateRow.of(this.metadata, this.protocol, this.readSchema.toJson(), structType.toJson(), structType2.toJson(), this.dataPath.toUri().toString());
    }

    @Override
    public Optional<Predicate> getRemainingFilter() {
        return this.getDataFilters();
    }

    private Optional<Tuple2<Predicate, Predicate>> splitFilters(Optional<Predicate> optional) {
        return optional.map(predicate -> PartitionUtils.splitMetadataAndDataPredicates(predicate, this.metadata.getPartitionColNames()));
    }

    private Optional<Predicate> getDataFilters() {
        return this.removeAlwaysTrue(this.partitionAndDataFilters.map(tuple2 -> (Predicate)tuple2._2));
    }

    private Optional<Predicate> getPartitionsFilters() {
        return this.removeAlwaysTrue(this.partitionAndDataFilters.map(tuple2 -> (Predicate)tuple2._1));
    }

    private Optional<Predicate> removeAlwaysTrue(Optional<Predicate> optional) {
        return optional.filter(predicate -> !predicate.getName().equalsIgnoreCase("ALWAYS_TRUE"));
    }

    private CloseableIterator<FilteredColumnarBatch> applyPartitionPruning(final Engine engine, final CloseableIterator<FilteredColumnarBatch> closeableIterator) {
        Optional<Predicate> optional = this.getPartitionsFilters();
        if (!optional.isPresent()) {
            return closeableIterator;
        }
        final Predicate predicate = PartitionUtils.rewritePartitionPredicateOnScanFileSchema(optional.get(), this.partitionColToStructFieldMap.get());
        return new CloseableIterator<FilteredColumnarBatch>(){
            PredicateEvaluator predicateEvaluator = null;

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public FilteredColumnarBatch next() {
                FilteredColumnarBatch filteredColumnarBatch = (FilteredColumnarBatch)closeableIterator.next();
                if (this.predicateEvaluator == null) {
                    this.predicateEvaluator = DeltaErrors.wrapEngineException(() -> engine.getExpressionHandler().getPredicateEvaluator(filteredColumnarBatch.getData().getSchema(), predicate), "Get the predicate evaluator for partition pruning with schema=%s and filter=%s", filteredColumnarBatch.getData().getSchema(), predicate);
                }
                ColumnVector columnVector = DeltaErrors.wrapEngineException(() -> this.predicateEvaluator.eval(filteredColumnarBatch.getData(), filteredColumnarBatch.getSelectionVector()), "Evaluating the partition expression %s", predicate);
                return new FilteredColumnarBatch(filteredColumnarBatch.getData(), Optional.of(columnVector));
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }

    private Optional<DataSkippingPredicate> getDataSkippingFilter() {
        return this.getDataFilters().flatMap(predicate -> DataSkippingUtils.constructDataSkippingFilter(predicate, this.metadata.getDataSchema()));
    }

    private CloseableIterator<FilteredColumnarBatch> applyDataSkipping(Engine engine, CloseableIterator<FilteredColumnarBatch> closeableIterator, DataSkippingPredicate dataSkippingPredicate) {
        StructType structType = DataSkippingUtils.pruneStatsSchema(StatsSchemaHelper.getStatsSchema(this.metadata.getDataSchema()), dataSkippingPredicate.getReferencedCols());
        Predicate predicate = new Predicate("=", new ScalarExpression("COALESCE", Arrays.asList(dataSkippingPredicate, Literal.ofBoolean(true))), AlwaysTrue.ALWAYS_TRUE);
        PredicateEvaluator predicateEvaluator = DeltaErrors.wrapEngineException(() -> engine.getExpressionHandler().getPredicateEvaluator(structType, predicate), "Get the predicate evaluator for data skipping with schema=%s and filter=%s", structType, predicate);
        return closeableIterator.map(filteredColumnarBatch -> {
            ColumnVector columnVector = DeltaErrors.wrapEngineException(() -> predicateEvaluator.eval(DataSkippingUtils.parseJsonStats(engine, filteredColumnarBatch, structType), filteredColumnarBatch.getSelectionVector()), "Evaluating the data skipping filter %s", predicate);
            return new FilteredColumnarBatch(filteredColumnarBatch.getData(), Optional.of(columnVector));
        });
    }

    private CloseableIterator<FilteredColumnarBatch> wrapWithMetricsReporting(final CloseableIterator<FilteredColumnarBatch> closeableIterator, final ScanReportReporter scanReportReporter) {
        return new CloseableIterator<FilteredColumnarBatch>(){
            private boolean errorReported = false;

            @Override
            public void close() throws IOException {
                try {
                    if (!this.errorReported) {
                        if (!closeableIterator.hasNext()) {
                            scanReportReporter.reportCompleteScan();
                        } else {
                            scanReportReporter.reportIncompleteScan();
                        }
                    }
                }
                finally {
                    closeableIterator.close();
                }
            }

            @Override
            public boolean hasNext() {
                return this.wrapWithErrorReporting(() -> closeableIterator.hasNext());
            }

            @Override
            public FilteredColumnarBatch next() {
                return this.wrapWithErrorReporting(() -> (FilteredColumnarBatch)closeableIterator.next());
            }

            private <T> T wrapWithErrorReporting(Supplier<T> supplier) {
                try {
                    return supplier.get();
                }
                catch (Exception exception) {
                    scanReportReporter.reportError(exception);
                    this.errorReported = true;
                    throw exception;
                }
            }
        };
    }

    private static interface ScanReportReporter {
        default public void reportError(Exception exception) {
            this.report(Optional.of(exception), false);
        }

        default public void reportCompleteScan() {
            this.report(Optional.empty(), true);
        }

        default public void reportIncompleteScan() {
            this.report(Optional.empty(), false);
        }

        public void report(Optional<Exception> var1, boolean var2);
    }
}

