/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.expressions;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.expressions.Expression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

@Evolving
public class ScalarExpression
implements Expression {
    protected final String name;
    protected final List<Expression> children;

    public ScalarExpression(String string, List<Expression> list) {
        this.name = Objects.requireNonNull(string, "name is null").toUpperCase(Locale.ENGLISH);
        this.children = Collections.unmodifiableList(new ArrayList<Expression>(list));
    }

    public String toString() {
        return String.format("%s(%s)", this.name, this.children.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<Expression> getChildren() {
        return this.children;
    }
}

